// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

using System.Runtime.Serialization;

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// Network plugin used for building the Kubernetes network.
/// </summary>
public enum ContainerServiceNetworkPlugin
{
    /// <summary>
    /// Use the Azure CNI network plugin. See [Azure CNI (advanced)
    /// networking](https://docs.microsoft.com/azure/aks/concepts-network#azure-cni-advanced-networking)
    /// for more information.
    /// </summary>
    [DataMember(Name = "azure")]
    Azure,

    /// <summary>
    /// Use the Kubenet network plugin. See [Kubenet (basic)
    /// networking](https://docs.microsoft.com/azure/aks/concepts-network#kubenet-basic-networking)
    /// for more information.
    /// </summary>
    [DataMember(Name = "kubenet")]
    Kubenet,

    /// <summary>
    /// No CNI plugin is pre-installed. See [BYO
    /// CNI](https://docs.microsoft.com/en-us/azure/aks/use-byo-cni) for more
    /// information.
    /// </summary>
    [DataMember(Name = "none")]
    None,
}
