// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// Maintenance window used to configure scheduled auto-upgrade for a Managed
/// Cluster.
/// </summary>
public partial class ContainerServiceMaintenanceWindow : ProvisionableConstruct
{
    /// <summary>
    /// Recurrence schedule for the maintenance window.
    /// </summary>
    public ContainerServiceMaintenanceSchedule Schedule 
    {
        get { Initialize(); return _schedule!; }
        set { Initialize(); AssignOrReplace(ref _schedule, value); }
    }
    private ContainerServiceMaintenanceSchedule? _schedule;

    /// <summary>
    /// Length of maintenance window range from 4 to 24 hours.
    /// </summary>
    public BicepValue<int> DurationHours 
    {
        get { Initialize(); return _durationHours!; }
        set { Initialize(); _durationHours!.Assign(value); }
    }
    private BicepValue<int>? _durationHours;

    /// <summary>
    /// The UTC offset in format +/-HH:mm. For example, &apos;+05:30&apos; for
    /// IST and &apos;-07:00&apos; for PST. If not specified, the default is
    /// &apos;+00:00&apos;.
    /// </summary>
    public BicepValue<string> UtcOffset 
    {
        get { Initialize(); return _utcOffset!; }
        set { Initialize(); _utcOffset!.Assign(value); }
    }
    private BicepValue<string>? _utcOffset;

    /// <summary>
    /// The date the maintenance window activates. If the current date is
    /// before this date, the maintenance window is inactive and will not be
    /// used for upgrades. If not specified, the maintenance window will be
    /// active right away.
    /// </summary>
    public BicepValue<string> StartDate 
    {
        get { Initialize(); return _startDate!; }
        set { Initialize(); _startDate!.Assign(value); }
    }
    private BicepValue<string>? _startDate;

    /// <summary>
    /// The start time of the maintenance window. Accepted values are from
    /// &apos;00:00&apos; to &apos;23:59&apos;. &apos;utcOffset&apos; applies
    /// to this field. For example: &apos;02:00&apos; with &apos;utcOffset:
    /// +02:00&apos; means UTC time &apos;00:00&apos;.
    /// </summary>
    public BicepValue<string> StartTime 
    {
        get { Initialize(); return _startTime!; }
        set { Initialize(); _startTime!.Assign(value); }
    }
    private BicepValue<string>? _startTime;

    /// <summary>
    /// Date ranges on which upgrade is not allowed. &apos;utcOffset&apos;
    /// applies to this field. For example, with &apos;utcOffset: +02:00&apos;
    /// and &apos;dateSpan&apos; being &apos;2022-12-23&apos; to
    /// &apos;2023-01-03&apos;, maintenance will be blocked from
    /// &apos;2022-12-22 22:00&apos; to &apos;2023-01-03 22:00&apos; in UTC
    /// time.
    /// </summary>
    public BicepList<ContainerServiceDateSpan> NotAllowedDates 
    {
        get { Initialize(); return _notAllowedDates!; }
        set { Initialize(); _notAllowedDates!.Assign(value); }
    }
    private BicepList<ContainerServiceDateSpan>? _notAllowedDates;

    /// <summary>
    /// Creates a new ContainerServiceMaintenanceWindow.
    /// </summary>
    public ContainerServiceMaintenanceWindow()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerServiceMaintenanceWindow.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _schedule = DefineModelProperty<ContainerServiceMaintenanceSchedule>("Schedule", ["schedule"]);
        _durationHours = DefineProperty<int>("DurationHours", ["durationHours"]);
        _utcOffset = DefineProperty<string>("UtcOffset", ["utcOffset"]);
        _startDate = DefineProperty<string>("StartDate", ["startDate"]);
        _startTime = DefineProperty<string>("StartTime", ["startTime"]);
        _notAllowedDates = DefineListProperty<ContainerServiceDateSpan>("NotAllowedDates", ["notAllowedDates"]);
    }
}
