// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// For schedules like: &apos;recur every Monday&apos; or &apos;recur every 3
/// weeks on Wednesday&apos;.
/// </summary>
public partial class ContainerServiceMaintenanceWeeklySchedule : ProvisionableConstruct
{
    /// <summary>
    /// Specifies the number of weeks between each set of occurrences.
    /// </summary>
    public BicepValue<int> IntervalWeeks 
    {
        get { Initialize(); return _intervalWeeks!; }
        set { Initialize(); _intervalWeeks!.Assign(value); }
    }
    private BicepValue<int>? _intervalWeeks;

    /// <summary>
    /// Specifies on which day of the week the maintenance occurs.
    /// </summary>
    public BicepValue<ContainerServiceWeekDay> DayOfWeek 
    {
        get { Initialize(); return _dayOfWeek!; }
        set { Initialize(); _dayOfWeek!.Assign(value); }
    }
    private BicepValue<ContainerServiceWeekDay>? _dayOfWeek;

    /// <summary>
    /// Creates a new ContainerServiceMaintenanceWeeklySchedule.
    /// </summary>
    public ContainerServiceMaintenanceWeeklySchedule()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerServiceMaintenanceWeeklySchedule.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _intervalWeeks = DefineProperty<int>("IntervalWeeks", ["intervalWeeks"]);
        _dayOfWeek = DefineProperty<ContainerServiceWeekDay>("DayOfWeek", ["dayOfWeek"]);
    }
}
