// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// For schedules like: &apos;recur every month on the 15th&apos; or
/// &apos;recur every 3 months on the 20th&apos;.
/// </summary>
public partial class ContainerServiceMaintenanceAbsoluteMonthlySchedule : ProvisionableConstruct
{
    /// <summary>
    /// Specifies the number of months between each set of occurrences.
    /// </summary>
    public BicepValue<int> IntervalMonths 
    {
        get { Initialize(); return _intervalMonths!; }
        set { Initialize(); _intervalMonths!.Assign(value); }
    }
    private BicepValue<int>? _intervalMonths;

    /// <summary>
    /// The date of the month.
    /// </summary>
    public BicepValue<int> DayOfMonth 
    {
        get { Initialize(); return _dayOfMonth!; }
        set { Initialize(); _dayOfMonth!.Assign(value); }
    }
    private BicepValue<int>? _dayOfMonth;

    /// <summary>
    /// Creates a new ContainerServiceMaintenanceAbsoluteMonthlySchedule.
    /// </summary>
    public ContainerServiceMaintenanceAbsoluteMonthlySchedule()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerServiceMaintenanceAbsoluteMonthlySchedule.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _intervalMonths = DefineProperty<int>("IntervalMonths", ["intervalMonths"]);
        _dayOfMonth = DefineProperty<int>("DayOfMonth", ["dayOfMonth"]);
    }
}
