// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// Profile for Linux VMs in the container service cluster.
/// </summary>
public partial class ContainerServiceLinuxProfile : ProvisionableConstruct
{
    /// <summary>
    /// The administrator username to use for Linux VMs.
    /// </summary>
    public BicepValue<string> AdminUsername 
    {
        get { Initialize(); return _adminUsername!; }
        set { Initialize(); _adminUsername!.Assign(value); }
    }
    private BicepValue<string>? _adminUsername;

    /// <summary>
    /// The list of SSH public keys used to authenticate with Linux-based VMs.
    /// A maximum of 1 key may be specified.
    /// </summary>
    public BicepList<ContainerServiceSshPublicKey> SshPublicKeys 
    {
        get { Initialize(); return _sshPublicKeys!; }
        set { Initialize(); _sshPublicKeys!.Assign(value); }
    }
    private BicepList<ContainerServiceSshPublicKey>? _sshPublicKeys;

    /// <summary>
    /// Creates a new ContainerServiceLinuxProfile.
    /// </summary>
    public ContainerServiceLinuxProfile()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerServiceLinuxProfile.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _adminUsername = DefineProperty<string>("AdminUsername", ["adminUsername"]);
        _sshPublicKeys = DefineListProperty<ContainerServiceSshPublicKey>("SshPublicKeys", ["ssh", "publicKeys"]);
    }
}
