// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// Contains the IPTag associated with the object.
/// </summary>
public partial class ContainerServiceIPTag : ProvisionableConstruct
{
    /// <summary>
    /// The IP tag type. Example: RoutingPreference.
    /// </summary>
    public BicepValue<string> IPTagType 
    {
        get { Initialize(); return _iPTagType!; }
        set { Initialize(); _iPTagType!.Assign(value); }
    }
    private BicepValue<string>? _iPTagType;

    /// <summary>
    /// The value of the IP tag associated with the public IP. Example:
    /// Internet.
    /// </summary>
    public BicepValue<string> Tag 
    {
        get { Initialize(); return _tag!; }
        set { Initialize(); _tag!.Assign(value); }
    }
    private BicepValue<string>? _tag;

    /// <summary>
    /// Creates a new ContainerServiceIPTag.
    /// </summary>
    public ContainerServiceIPTag()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerServiceIPTag.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _iPTagType = DefineProperty<string>("IPTagType", ["ipTagType"]);
        _tag = DefineProperty<string>("Tag", ["tag"]);
    }
}
