// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

using System.Runtime.Serialization;

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// If not specified, the default is &apos;random&apos;. See
/// [expanders](https://github.com/kubernetes/autoscaler/blob/master/cluster-autoscaler/FAQ.md#what-are-expanders)
/// for more information.
/// </summary>
public enum AutoScaleExpander
{
    /// <summary>
    /// Selects the node group that will have the least idle CPU (if tied,
    /// unused memory) after scale-up. This is useful when you have different
    /// classes of nodes, for example, high CPU or high memory nodes, and only
    /// want to expand those when there are pending pods that need a lot of
    /// those resources.
    /// </summary>
    [DataMember(Name = "least-waste")]
    LeastWaste,

    /// <summary>
    /// Selects the node group that would be able to schedule the most pods
    /// when scaling up. This is useful when you are using nodeSelector to
    /// make sure certain pods land on certain nodes. Note that this
    /// won&apos;t cause the autoscaler to select bigger nodes vs. smaller, as
    /// it can add multiple smaller nodes at once.
    /// </summary>
    [DataMember(Name = "most-pods")]
    MostPods,

    /// <summary>
    /// Selects the node group that has the highest priority assigned by the
    /// user. It&apos;s configuration is described in more details
    /// [here](https://github.com/kubernetes/autoscaler/blob/master/cluster-autoscaler/expander/priority/readme.md).
    /// </summary>
    [DataMember(Name = "priority")]
    Priority,

    /// <summary>
    /// Used when you don&apos;t have a particular need for the node groups to
    /// scale differently.
    /// </summary>
    [DataMember(Name = "random")]
    Random,
}
