// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// The port range.
/// </summary>
public partial class AgentPoolNetworkPortRange : ProvisionableConstruct
{
    /// <summary>
    /// The minimum port that is included in the range. It should be ranged
    /// from 1 to 65535, and be less than or equal to portEnd.
    /// </summary>
    public BicepValue<int> PortStart 
    {
        get { Initialize(); return _portStart!; }
        set { Initialize(); _portStart!.Assign(value); }
    }
    private BicepValue<int>? _portStart;

    /// <summary>
    /// The maximum port that is included in the range. It should be ranged
    /// from 1 to 65535, and be greater than or equal to portStart.
    /// </summary>
    public BicepValue<int> PortEnd 
    {
        get { Initialize(); return _portEnd!; }
        set { Initialize(); _portEnd!.Assign(value); }
    }
    private BicepValue<int>? _portEnd;

    /// <summary>
    /// The network protocol of the port.
    /// </summary>
    public BicepValue<AgentPoolNetworkPortProtocol> Protocol 
    {
        get { Initialize(); return _protocol!; }
        set { Initialize(); _protocol!.Assign(value); }
    }
    private BicepValue<AgentPoolNetworkPortProtocol>? _protocol;

    /// <summary>
    /// Creates a new AgentPoolNetworkPortRange.
    /// </summary>
    public AgentPoolNetworkPortRange()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of AgentPoolNetworkPortRange.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _portStart = DefineProperty<int>("PortStart", ["portStart"]);
        _portEnd = DefineProperty<int>("PortEnd", ["portEnd"]);
        _protocol = DefineProperty<AgentPoolNetworkPortProtocol>("Protocol", ["protocol"]);
    }
}
