// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// A cluster must have at least one &apos;System&apos; Agent Pool at all
/// times. For additional information on agent pool restrictions and best
/// practices, see: https://docs.microsoft.com/azure/aks/use-system-pools.
/// </summary>
public enum AgentPoolMode
{
    /// <summary>
    /// System agent pools are primarily for hosting critical system pods such
    /// as CoreDNS and metrics-server. System agent pools osType must be
    /// Linux. System agent pools VM SKU must have at least 2vCPUs and 4GB of
    /// memory.
    /// </summary>
    System,

    /// <summary>
    /// User agent pools are primarily for hosting your application pods.
    /// </summary>
    User,
}
