// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using System;
using System.ComponentModel;

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// Built-in ContainerService roles that you can assign to users, groups,
/// service principals, and managed identities.
/// </summary>
/// <param name="value">The ID value of the role.</param>
public readonly struct ContainerServiceBuiltInRole(string value) : IEquatable<ContainerServiceBuiltInRole>
{
    private readonly string _value = value ?? throw new ArgumentNullException(nameof(value));

    /// <summary>
    /// List cluster admin credential action.
    /// </summary>
    public static ContainerServiceBuiltInRole AzureKubernetesServiceClusterAdminRole { get; } = new(AzureKubernetesServiceClusterAdminRoleValue);
    internal const string AzureKubernetesServiceClusterAdminRoleValue = "0ab0b1a8-8aac-4efd-b8c2-3ee1fb270be8";

    /// <summary>
    /// List cluster monitoring user credential action.
    /// </summary>
    public static ContainerServiceBuiltInRole AzureKubernetesServiceClusterMonitoringUser { get; } = new(AzureKubernetesServiceClusterMonitoringUserValue);
    internal const string AzureKubernetesServiceClusterMonitoringUserValue = "1afdec4b-e479-420e-99e7-f82237c7c5e6";

    /// <summary>
    /// List cluster user credential action.
    /// </summary>
    public static ContainerServiceBuiltInRole AzureKubernetesServiceClusterUserRole { get; } = new(AzureKubernetesServiceClusterUserRoleValue);
    internal const string AzureKubernetesServiceClusterUserRoleValue = "4abbcc35-e782-43d8-92c5-2d3f1bd2253f";

    /// <summary>
    /// Grants access to read and write Azure Kubernetes Service clusters
    /// </summary>
    public static ContainerServiceBuiltInRole AzureKubernetesServiceContributorRole { get; } = new(AzureKubernetesServiceContributorRoleValue);
    internal const string AzureKubernetesServiceContributorRoleValue = "ed7f3fbd-7b88-4dd4-9017-9adb7ce333f8";

    /// <summary>
    /// Lets you manage all resources under cluster/namespace, except update or
    /// delete resource quotas and namespaces.
    /// </summary>
    public static ContainerServiceBuiltInRole AzureKubernetesServiceRbacAdmin { get; } = new(AzureKubernetesServiceRbacAdminValue);
    internal const string AzureKubernetesServiceRbacAdminValue = "3498e952-d568-435e-9b2c-8d77e338d7f7";

    /// <summary>
    /// Lets you manage all resources in the cluster.
    /// </summary>
    public static ContainerServiceBuiltInRole AzureKubernetesServiceRbacClusterAdmin { get; } = new(AzureKubernetesServiceRbacClusterAdminValue);
    internal const string AzureKubernetesServiceRbacClusterAdminValue = "b1ff04bb-8a4e-4dc4-8eb5-8693973ce19b";

    /// <summary>
    /// Allows read-only access to see most objects in a namespace. It does not
    /// allow viewing roles or role bindings. This role does not allow viewing
    /// Secrets, since reading the contents of Secrets enables access to
    /// ServiceAccount credentials in the namespace, which would allow API
    /// access as any ServiceAccount in the namespace (a form of privilege
    /// escalation). Applying this role at cluster scope will give access
    /// across all namespaces.
    /// </summary>
    public static ContainerServiceBuiltInRole AzureKubernetesServiceRbacReader { get; } = new(AzureKubernetesServiceRbacReaderValue);
    internal const string AzureKubernetesServiceRbacReaderValue = "7f6c6a51-bcf8-42ba-9220-52d62157d7db";

    /// <summary>
    /// Allows read/write access to most objects in a namespace. This role does
    /// not allow viewing or modifying roles or role bindings. However, this
    /// role allows accessing Secrets and running Pods as any ServiceAccount
    /// in the namespace, so it can be used to gain the API access levels of
    /// any ServiceAccount in the namespace. Applying this role at cluster
    /// scope will give access across all namespaces.
    /// </summary>
    public static ContainerServiceBuiltInRole AzureKubernetesServiceRbacWriter { get; } = new(AzureKubernetesServiceRbacWriterValue);
    internal const string AzureKubernetesServiceRbacWriterValue = "a7ffa36f-339b-4b5c-8bdf-e2c188b2c0eb";

    /// <summary>
    /// Try to get the name of a built-in ContainerService role from its ID
    /// value.
    /// </summary>
    /// <param name="value">The role value.</param>
    /// <returns>
    /// The name of the built-in ContainerService role if known, otherwise the ID will be returned.
    /// </returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public static string GetBuiltInRoleName(ContainerServiceBuiltInRole value) =>
        value._value switch
        {
            AzureKubernetesServiceClusterAdminRoleValue => nameof(AzureKubernetesServiceClusterAdminRole),
            AzureKubernetesServiceClusterMonitoringUserValue => nameof(AzureKubernetesServiceClusterMonitoringUser),
            AzureKubernetesServiceClusterUserRoleValue => nameof(AzureKubernetesServiceClusterUserRole),
            AzureKubernetesServiceContributorRoleValue => nameof(AzureKubernetesServiceContributorRole),
            AzureKubernetesServiceRbacAdminValue => nameof(AzureKubernetesServiceRbacAdmin),
            AzureKubernetesServiceRbacClusterAdminValue => nameof(AzureKubernetesServiceRbacClusterAdmin),
            AzureKubernetesServiceRbacReaderValue => nameof(AzureKubernetesServiceRbacReader),
            AzureKubernetesServiceRbacWriterValue => nameof(AzureKubernetesServiceRbacWriter),
            _ => value._value
        };

    /// <summary>
    /// Determines if two ContainerServiceBuiltInRole values are the same.
    /// </summary>
    /// <param name="left">The first ContainerServiceBuiltInRole to compare.</param>
    /// <param name="right">The second ContainerServiceBuiltInRole to compare.</param>
    /// <returns>True if <paramref name="left"/> and <paramref name="right"/> are the same; otherwise, false.</returns>
    public static bool operator ==(ContainerServiceBuiltInRole left, ContainerServiceBuiltInRole right) => left.Equals(right);

    /// <summary>
    /// Determines if two ContainerServiceBuiltInRole values are different.
    /// </summary>
    /// <param name="left">The first ContainerServiceBuiltInRole to compare.</param>
    /// <param name="right">The second ContainerServiceBuiltInRole to compare.</param>
    /// <returns>True if <paramref name="left"/> and <paramref name="right"/> are different; otherwise, false.</returns>
    public static bool operator !=(ContainerServiceBuiltInRole left, ContainerServiceBuiltInRole right) => !left.Equals(right);

    /// <summary>
    /// Converts a string to a ContainerServiceBuiltInRole.
    /// </summary>
    /// <param name="value">The string value to convert.</param>
    public static implicit operator ContainerServiceBuiltInRole(string value) => new(value);

    /// <inheritdoc/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override bool Equals(object? obj) => obj is ContainerServiceBuiltInRole other && Equals(other);

    /// <inheritdoc/>
    public bool Equals(ContainerServiceBuiltInRole other) => string.Equals(_value, other._value, StringComparison.Ordinal);

    /// <inheritdoc/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override int GetHashCode() => _value?.GetHashCode() ?? 0;

    /// <inheritdoc/>
    public override string ToString() => _value;
}
