// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;
using System.ComponentModel;

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// ContainerServiceAgentPool.
/// </summary>
public partial class ContainerServiceAgentPool : ProvisionableResource
{
    /// <summary>
    /// The name of the agent pool.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The list of Availability zones to use for nodes. This can only be
    /// specified if the AgentPoolType property is
    /// &apos;VirtualMachineScaleSets&apos;.
    /// </summary>
    public BicepList<string> AvailabilityZones 
    {
        get { Initialize(); return _availabilityZones!; }
        set { Initialize(); _availabilityZones!.Assign(value); }
    }
    private BicepList<string>? _availabilityZones;

    /// <summary>
    /// AKS will associate the specified agent pool with the Capacity
    /// Reservation Group.
    /// </summary>
    public BicepValue<ResourceIdentifier> CapacityReservationGroupId 
    {
        get { Initialize(); return _capacityReservationGroupId!; }
        set { Initialize(); _capacityReservationGroupId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _capacityReservationGroupId;

    /// <summary>
    /// Number of agents (VMs) to host docker containers. Allowed values must
    /// be in the range of 0 to 1000 (inclusive) for user pools and in the
    /// range of 1 to 1000 (inclusive) for system pools. The default value is
    /// 1.
    /// </summary>
    public BicepValue<int> Count 
    {
        get { Initialize(); return _count!; }
        set { Initialize(); _count!.Assign(value); }
    }
    private BicepValue<int>? _count;

    /// <summary>
    /// This is the ARM ID of the source object to be used to create the target
    /// object.
    /// </summary>
    public BicepValue<ResourceIdentifier> CreationDataSourceResourceId 
    {
        get { Initialize(); return _creationDataSourceResourceId!; }
        set { Initialize(); _creationDataSourceResourceId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _creationDataSourceResourceId;

    /// <summary>
    /// Whether to enable auto-scaler.
    /// </summary>
    public BicepValue<bool> EnableAutoScaling 
    {
        get { Initialize(); return _enableAutoScaling!; }
        set { Initialize(); _enableAutoScaling!.Assign(value); }
    }
    private BicepValue<bool>? _enableAutoScaling;

    /// <summary>
    /// This is only supported on certain VM sizes and in certain Azure
    /// regions. For more information, see:
    /// https://docs.microsoft.com/azure/aks/enable-host-encryption.
    /// </summary>
    public BicepValue<bool> EnableEncryptionAtHost 
    {
        get { Initialize(); return _enableEncryptionAtHost!; }
        set { Initialize(); _enableEncryptionAtHost!.Assign(value); }
    }
    private BicepValue<bool>? _enableEncryptionAtHost;

    /// <summary>
    /// See [Add a FIPS-enabled node
    /// pool](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview)
    /// for more details.
    /// </summary>
    public BicepValue<bool> EnableFips 
    {
        get { Initialize(); return _enableFips!; }
        set { Initialize(); _enableFips!.Assign(value); }
    }
    private BicepValue<bool>? _enableFips;

    /// <summary>
    /// Some scenarios may require nodes in a node pool to receive their own
    /// dedicated public IP addresses. A common scenario is for gaming
    /// workloads, where a console needs to make a direct connection to a
    /// cloud virtual machine to minimize hops. For more information see
    /// [assigning a public IP per
    /// node](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#assign-a-public-ip-per-node-for-your-node-pools).
    /// The default is false.
    /// </summary>
    public BicepValue<bool> EnableNodePublicIP 
    {
        get { Initialize(); return _enableNodePublicIP!; }
        set { Initialize(); _enableNodePublicIP!.Assign(value); }
    }
    private BicepValue<bool>? _enableNodePublicIP;

    /// <summary>
    /// Whether to enable UltraSSD.
    /// </summary>
    public BicepValue<bool> EnableUltraSsd 
    {
        get { Initialize(); return _enableUltraSsd!; }
        set { Initialize(); _enableUltraSsd!.Assign(value); }
    }
    private BicepValue<bool>? _enableUltraSsd;

    /// <summary>
    /// GPUInstanceProfile to be used to specify GPU MIG instance profile for
    /// supported GPU VM SKU.
    /// </summary>
    public BicepValue<GpuInstanceProfile> GpuInstanceProfile 
    {
        get { Initialize(); return _gpuInstanceProfile!; }
        set { Initialize(); _gpuInstanceProfile!.Assign(value); }
    }
    private BicepValue<GpuInstanceProfile>? _gpuInstanceProfile;

    /// <summary>
    /// This is of the form:
    /// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}.
    /// For more information see [Azure dedicated
    /// hosts](https://docs.microsoft.com/azure/virtual-machines/dedicated-hosts).
    /// </summary>
    public BicepValue<ResourceIdentifier> HostGroupId 
    {
        get { Initialize(); return _hostGroupId!; }
        set { Initialize(); _hostGroupId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _hostGroupId;

    /// <summary>
    /// The Kubelet configuration on the agent pool nodes.
    /// </summary>
    public KubeletConfig KubeletConfig 
    {
        get { Initialize(); return _kubeletConfig!; }
        set { Initialize(); AssignOrReplace(ref _kubeletConfig, value); }
    }
    private KubeletConfig? _kubeletConfig;

    /// <summary>
    /// Determines the placement of emptyDir volumes, container runtime data
    /// root, and Kubelet ephemeral storage.
    /// </summary>
    public BicepValue<KubeletDiskType> KubeletDiskType 
    {
        get { Initialize(); return _kubeletDiskType!; }
        set { Initialize(); _kubeletDiskType!.Assign(value); }
    }
    private BicepValue<KubeletDiskType>? _kubeletDiskType;

    /// <summary>
    /// The OS configuration of Linux agent nodes.
    /// </summary>
    public LinuxOSConfig LinuxOSConfig 
    {
        get { Initialize(); return _linuxOSConfig!; }
        set { Initialize(); AssignOrReplace(ref _linuxOSConfig, value); }
    }
    private LinuxOSConfig? _linuxOSConfig;

    /// <summary>
    /// The maximum number of nodes for auto-scaling.
    /// </summary>
    public BicepValue<int> MaxCount 
    {
        get { Initialize(); return _maxCount!; }
        set { Initialize(); _maxCount!.Assign(value); }
    }
    private BicepValue<int>? _maxCount;

    /// <summary>
    /// The maximum number of pods that can run on a node.
    /// </summary>
    public BicepValue<int> MaxPods 
    {
        get { Initialize(); return _maxPods!; }
        set { Initialize(); _maxPods!.Assign(value); }
    }
    private BicepValue<int>? _maxPods;

    /// <summary>
    /// The minimum number of nodes for auto-scaling.
    /// </summary>
    public BicepValue<int> MinCount 
    {
        get { Initialize(); return _minCount!; }
        set { Initialize(); _minCount!.Assign(value); }
    }
    private BicepValue<int>? _minCount;

    /// <summary>
    /// A cluster must have at least one &apos;System&apos; Agent Pool at all
    /// times. For additional information on agent pool restrictions and best
    /// practices, see: https://docs.microsoft.com/azure/aks/use-system-pools.
    /// </summary>
    public BicepValue<AgentPoolMode> Mode 
    {
        get { Initialize(); return _mode!; }
        set { Initialize(); _mode!.Assign(value); }
    }
    private BicepValue<AgentPoolMode>? _mode;

    /// <summary>
    /// Network-related settings of an agent pool.
    /// </summary>
    public AgentPoolNetworkProfile NetworkProfile 
    {
        get { Initialize(); return _networkProfile!; }
        set { Initialize(); AssignOrReplace(ref _networkProfile, value); }
    }
    private AgentPoolNetworkProfile? _networkProfile;

    /// <summary>
    /// The node labels to be persisted across all nodes in agent pool.
    /// </summary>
    public BicepDictionary<string> NodeLabels 
    {
        get { Initialize(); return _nodeLabels!; }
        set { Initialize(); _nodeLabels!.Assign(value); }
    }
    private BicepDictionary<string>? _nodeLabels;

    /// <summary>
    /// This is of the form:
    /// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIPPrefixName}.
    /// </summary>
    public BicepValue<ResourceIdentifier> NodePublicIPPrefixId 
    {
        get { Initialize(); return _nodePublicIPPrefixId!; }
        set { Initialize(); _nodePublicIPPrefixId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _nodePublicIPPrefixId;

    /// <summary>
    /// The taints added to new nodes during node pool create and scale. For
    /// example, key=value:NoSchedule.
    /// </summary>
    public BicepList<string> NodeTaints 
    {
        get { Initialize(); return _nodeTaints!; }
        set { Initialize(); _nodeTaints!.Assign(value); }
    }
    private BicepList<string>? _nodeTaints;

    /// <summary>
    /// Both patch version &lt;major.minor.patch&gt; (e.g. 1.20.13) and
    /// &lt;major.minor&gt; (e.g. 1.20) are supported. When
    /// &lt;major.minor&gt; is specified, the latest supported GA patch
    /// version is chosen automatically. Updating the cluster with the same
    /// &lt;major.minor&gt; once it has been created (e.g. 1.14.x -&gt; 1.14)
    /// will not trigger an upgrade, even if a newer patch version is
    /// available. As a best practice, you should upgrade all node pools in an
    /// AKS cluster to the same Kubernetes version. The node pool version must
    /// have the same major version as the control plane. The node pool minor
    /// version must be within two minor versions of the control plane
    /// version. The node pool version cannot be greater than the control
    /// plane version. For more information see [upgrading a node
    /// pool](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#upgrade-a-node-pool).
    /// </summary>
    public BicepValue<string> OrchestratorVersion 
    {
        get { Initialize(); return _orchestratorVersion!; }
        set { Initialize(); _orchestratorVersion!.Assign(value); }
    }
    private BicepValue<string>? _orchestratorVersion;

    /// <summary>
    /// OS Disk Size in GB to be used to specify the disk size for every
    /// machine in the master/agent pool. If you specify 0, it will apply the
    /// default osDisk size according to the vmSize specified.
    /// </summary>
    public BicepValue<int> OSDiskSizeInGB 
    {
        get { Initialize(); return _oSDiskSizeInGB!; }
        set { Initialize(); _oSDiskSizeInGB!.Assign(value); }
    }
    private BicepValue<int>? _oSDiskSizeInGB;

    /// <summary>
    /// The default is &apos;Ephemeral&apos; if the VM supports it and has a
    /// cache disk larger than the requested OSDiskSizeGB. Otherwise, defaults
    /// to &apos;Managed&apos;. May not be changed after creation. For more
    /// information see [Ephemeral
    /// OS](https://docs.microsoft.com/azure/aks/cluster-configuration#ephemeral-os).
    /// </summary>
    public BicepValue<ContainerServiceOSDiskType> OSDiskType 
    {
        get { Initialize(); return _oSDiskType!; }
        set { Initialize(); _oSDiskType!.Assign(value); }
    }
    private BicepValue<ContainerServiceOSDiskType>? _oSDiskType;

    /// <summary>
    /// Specifies the OS SKU used by the agent pool. The default is Ubuntu if
    /// OSType is Linux. The default is Windows2019 when Kubernetes &lt;= 1.24
    /// or Windows2022 when Kubernetes &gt;= 1.25 if OSType is Windows.
    /// </summary>
    public BicepValue<ContainerServiceOSSku> OSSku 
    {
        get { Initialize(); return _oSSku!; }
        set { Initialize(); _oSSku!.Assign(value); }
    }
    private BicepValue<ContainerServiceOSSku>? _oSSku;

    /// <summary>
    /// The operating system type. The default is Linux.
    /// </summary>
    public BicepValue<ContainerServiceOSType> OSType 
    {
        get { Initialize(); return _oSType!; }
        set { Initialize(); _oSType!.Assign(value); }
    }
    private BicepValue<ContainerServiceOSType>? _oSType;

    /// <summary>
    /// If omitted, pod IPs are statically assigned on the node subnet (see
    /// vnetSubnetID for more details). This is of the form:
    /// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.
    /// </summary>
    public BicepValue<ResourceIdentifier> PodSubnetId 
    {
        get { Initialize(); return _podSubnetId!; }
        set { Initialize(); _podSubnetId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _podSubnetId;

    /// <summary>
    /// Tells whether the cluster is Running or Stopped.
    /// </summary>
    public BicepValue<ContainerServiceStateCode> PowerStateCode 
    {
        get { Initialize(); return _powerStateCode!; }
        set { Initialize(); _powerStateCode!.Assign(value); }
    }
    private BicepValue<ContainerServiceStateCode>? _powerStateCode;

    /// <summary>
    /// The ID for Proximity Placement Group.
    /// </summary>
    public BicepValue<ResourceIdentifier> ProximityPlacementGroupId 
    {
        get { Initialize(); return _proximityPlacementGroupId!; }
        set { Initialize(); _proximityPlacementGroupId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _proximityPlacementGroupId;

    /// <summary>
    /// This also effects the cluster autoscaler behavior. If not specified, it
    /// defaults to Delete.
    /// </summary>
    public BicepValue<ScaleDownMode> ScaleDownMode 
    {
        get { Initialize(); return _scaleDownMode!; }
        set { Initialize(); _scaleDownMode!.Assign(value); }
    }
    private BicepValue<ScaleDownMode>? _scaleDownMode;

    /// <summary>
    /// This cannot be specified unless the scaleSetPriority is
    /// &apos;Spot&apos;. If not specified, the default is &apos;Delete&apos;.
    /// </summary>
    public BicepValue<ScaleSetEvictionPolicy> ScaleSetEvictionPolicy 
    {
        get { Initialize(); return _scaleSetEvictionPolicy!; }
        set { Initialize(); _scaleSetEvictionPolicy!.Assign(value); }
    }
    private BicepValue<ScaleSetEvictionPolicy>? _scaleSetEvictionPolicy;

    /// <summary>
    /// The Virtual Machine Scale Set priority. If not specified, the default
    /// is &apos;Regular&apos;.
    /// </summary>
    public BicepValue<ScaleSetPriority> ScaleSetPriority 
    {
        get { Initialize(); return _scaleSetPriority!; }
        set { Initialize(); _scaleSetPriority!.Assign(value); }
    }
    private BicepValue<ScaleSetPriority>? _scaleSetPriority;

    /// <summary>
    /// Possible values are any decimal value greater than zero or -1 which
    /// indicates the willingness to pay any on-demand price. For more details
    /// on spot pricing, see [spot VMs
    /// pricing](https://docs.microsoft.com/azure/virtual-machines/spot-vms#pricing).
    /// </summary>
    public BicepValue<float> SpotMaxPrice 
    {
        get { Initialize(); return _spotMaxPrice!; }
        set { Initialize(); _spotMaxPrice!.Assign(value); }
    }
    private BicepValue<float>? _spotMaxPrice;

    /// <summary>
    /// The tags to be persisted on the agent pool virtual machine scale set.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// The type of Agent Pool.
    /// </summary>
    public BicepValue<AgentPoolType> TypePropertiesType 
    {
        get { Initialize(); return _typePropertiesType!; }
        set { Initialize(); _typePropertiesType!.Assign(value); }
    }
    private BicepValue<AgentPoolType>? _typePropertiesType;

    /// <summary>
    /// Settings for upgrading the agentpool.
    /// </summary>
    public AgentPoolUpgradeSettings UpgradeSettings 
    {
        get { Initialize(); return _upgradeSettings!; }
        set { Initialize(); AssignOrReplace(ref _upgradeSettings, value); }
    }
    private AgentPoolUpgradeSettings? _upgradeSettings;

    /// <summary>
    /// VM size availability varies by region. If a node contains insufficient
    /// compute resources (memory, cpu, etc) pods might fail to run correctly.
    /// For more details on restricted VM sizes, see:
    /// https://docs.microsoft.com/azure/aks/quotas-skus-regions.
    /// </summary>
    public BicepValue<string> VmSize 
    {
        get { Initialize(); return _vmSize!; }
        set { Initialize(); _vmSize!.Assign(value); }
    }
    private BicepValue<string>? _vmSize;

    /// <summary>
    /// If this is not specified, a VNET and subnet will be generated and used.
    /// If no podSubnetID is specified, this applies to nodes and pods,
    /// otherwise it applies to just nodes. This is of the form:
    /// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.
    /// </summary>
    public BicepValue<ResourceIdentifier> VnetSubnetId 
    {
        get { Initialize(); return _vnetSubnetId!; }
        set { Initialize(); _vnetSubnetId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _vnetSubnetId;

    /// <summary>
    /// Determines the type of workload a node can run.
    /// </summary>
    public BicepValue<WorkloadRuntime> WorkloadRuntime 
    {
        get { Initialize(); return _workloadRuntime!; }
        set { Initialize(); _workloadRuntime!.Assign(value); }
    }
    private BicepValue<WorkloadRuntime>? _workloadRuntime;

    /// <summary>
    /// If orchestratorVersion is a fully specified version
    /// &lt;major.minor.patch&gt;, this field will be exactly equal to it. If
    /// orchestratorVersion is &lt;major.minor&gt;, this field will contain
    /// the full &lt;major.minor.patch&gt; version being used.
    /// </summary>
    public BicepValue<string> CurrentOrchestratorVersion 
    {
        get { Initialize(); return _currentOrchestratorVersion!; }
    }
    private BicepValue<string>? _currentOrchestratorVersion;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// The version of node image.
    /// </summary>
    public BicepValue<string> NodeImageVersion 
    {
        get { Initialize(); return _nodeImageVersion!; }
    }
    private BicepValue<string>? _nodeImageVersion;

    /// <summary>
    /// The current deployment or provisioning state.
    /// </summary>
    public BicepValue<string> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<string>? _provisioningState;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent ContainerServiceManagedCluster.
    /// </summary>
    public ContainerServiceManagedCluster? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<ContainerServiceManagedCluster>? _parent;

    /// <summary>
    /// Creates a new ContainerServiceAgentPool.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ContainerServiceAgentPool
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ContainerServiceAgentPool.</param>
    public ContainerServiceAgentPool(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.ContainerService/managedClusters/agentPools", resourceVersion ?? "2024-08-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerServiceAgentPool.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _availabilityZones = DefineListProperty<string>("AvailabilityZones", ["properties", "availabilityZones"]);
        _capacityReservationGroupId = DefineProperty<ResourceIdentifier>("CapacityReservationGroupId", ["properties", "capacityReservationGroupID"]);
        _count = DefineProperty<int>("Count", ["properties", "count"]);
        _creationDataSourceResourceId = DefineProperty<ResourceIdentifier>("CreationDataSourceResourceId", ["properties", "creationData", "sourceResourceId"]);
        _enableAutoScaling = DefineProperty<bool>("EnableAutoScaling", ["properties", "enableAutoScaling"]);
        _enableEncryptionAtHost = DefineProperty<bool>("EnableEncryptionAtHost", ["properties", "enableEncryptionAtHost"]);
        _enableFips = DefineProperty<bool>("EnableFips", ["properties", "enableFIPS"]);
        _enableNodePublicIP = DefineProperty<bool>("EnableNodePublicIP", ["properties", "enableNodePublicIP"]);
        _enableUltraSsd = DefineProperty<bool>("EnableUltraSsd", ["properties", "enableUltraSSD"]);
        _gpuInstanceProfile = DefineProperty<GpuInstanceProfile>("GpuInstanceProfile", ["properties", "gpuInstanceProfile"]);
        _hostGroupId = DefineProperty<ResourceIdentifier>("HostGroupId", ["properties", "hostGroupID"]);
        _kubeletConfig = DefineModelProperty<KubeletConfig>("KubeletConfig", ["properties", "kubeletConfig"]);
        _kubeletDiskType = DefineProperty<KubeletDiskType>("KubeletDiskType", ["properties", "kubeletDiskType"]);
        _linuxOSConfig = DefineModelProperty<LinuxOSConfig>("LinuxOSConfig", ["properties", "linuxOSConfig"]);
        _maxCount = DefineProperty<int>("MaxCount", ["properties", "maxCount"]);
        _maxPods = DefineProperty<int>("MaxPods", ["properties", "maxPods"]);
        _minCount = DefineProperty<int>("MinCount", ["properties", "minCount"]);
        _mode = DefineProperty<AgentPoolMode>("Mode", ["properties", "mode"]);
        _networkProfile = DefineModelProperty<AgentPoolNetworkProfile>("NetworkProfile", ["properties", "networkProfile"]);
        _nodeLabels = DefineDictionaryProperty<string>("NodeLabels", ["properties", "nodeLabels"]);
        _nodePublicIPPrefixId = DefineProperty<ResourceIdentifier>("NodePublicIPPrefixId", ["properties", "nodePublicIPPrefixID"]);
        _nodeTaints = DefineListProperty<string>("NodeTaints", ["properties", "nodeTaints"]);
        _orchestratorVersion = DefineProperty<string>("OrchestratorVersion", ["properties", "orchestratorVersion"]);
        _oSDiskSizeInGB = DefineProperty<int>("OSDiskSizeInGB", ["properties", "osDiskSizeGB"]);
        _oSDiskType = DefineProperty<ContainerServiceOSDiskType>("OSDiskType", ["properties", "osDiskType"]);
        _oSSku = DefineProperty<ContainerServiceOSSku>("OSSku", ["properties", "osSKU"]);
        _oSType = DefineProperty<ContainerServiceOSType>("OSType", ["properties", "osType"]);
        _podSubnetId = DefineProperty<ResourceIdentifier>("PodSubnetId", ["properties", "podSubnetID"]);
        _powerStateCode = DefineProperty<ContainerServiceStateCode>("PowerStateCode", ["properties", "powerState", "code"]);
        _proximityPlacementGroupId = DefineProperty<ResourceIdentifier>("ProximityPlacementGroupId", ["properties", "proximityPlacementGroupID"]);
        _scaleDownMode = DefineProperty<ScaleDownMode>("ScaleDownMode", ["properties", "scaleDownMode"]);
        _scaleSetEvictionPolicy = DefineProperty<ScaleSetEvictionPolicy>("ScaleSetEvictionPolicy", ["properties", "scaleSetEvictionPolicy"]);
        _scaleSetPriority = DefineProperty<ScaleSetPriority>("ScaleSetPriority", ["properties", "scaleSetPriority"]);
        _spotMaxPrice = DefineProperty<float>("SpotMaxPrice", ["properties", "spotMaxPrice"]);
        _tags = DefineDictionaryProperty<string>("Tags", ["properties", "tags"]);
        _typePropertiesType = DefineProperty<AgentPoolType>("TypePropertiesType", ["properties", "type"]);
        _upgradeSettings = DefineModelProperty<AgentPoolUpgradeSettings>("UpgradeSettings", ["properties", "upgradeSettings"]);
        _vmSize = DefineProperty<string>("VmSize", ["properties", "vmSize"]);
        _vnetSubnetId = DefineProperty<ResourceIdentifier>("VnetSubnetId", ["properties", "vnetSubnetID"]);
        _workloadRuntime = DefineProperty<WorkloadRuntime>("WorkloadRuntime", ["properties", "workloadRuntime"]);
        _currentOrchestratorVersion = DefineProperty<string>("CurrentOrchestratorVersion", ["properties", "currentOrchestratorVersion"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _nodeImageVersion = DefineProperty<string>("NodeImageVersion", ["properties", "nodeImageVersion"], isOutput: true);
        _provisioningState = DefineProperty<string>("ProvisioningState", ["properties", "provisioningState"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<ContainerServiceManagedCluster>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported ContainerServiceAgentPool resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-08-01.
        /// </summary>
        public static readonly string V2024_08_01 = "2024-08-01";

        /// <summary>
        /// 2024-07-01.
        /// </summary>
        public static readonly string V2024_07_01 = "2024-07-01";

        /// <summary>
        /// 2024-06-01.
        /// </summary>
        public static readonly string V2024_06_01 = "2024-06-01";

        /// <summary>
        /// 2024-05-01.
        /// </summary>
        public static readonly string V2024_05_01 = "2024-05-01";

        /// <summary>
        /// 2024-02-01.
        /// </summary>
        public static readonly string V2024_02_01 = "2024-02-01";

        /// <summary>
        /// 2024-01-01.
        /// </summary>
        public static readonly string V2024_01_01 = "2024-01-01";

        /// <summary>
        /// 2023-11-01.
        /// </summary>
        public static readonly string V2023_11_01 = "2023-11-01";

        /// <summary>
        /// 2023-10-01.
        /// </summary>
        public static readonly string V2023_10_01 = "2023-10-01";

        /// <summary>
        /// 2023-09-01.
        /// </summary>
        public static readonly string V2023_09_01 = "2023-09-01";

        /// <summary>
        /// 2023-08-01.
        /// </summary>
        public static readonly string V2023_08_01 = "2023-08-01";

        /// <summary>
        /// 2023-07-01.
        /// </summary>
        public static readonly string V2023_07_01 = "2023-07-01";

        /// <summary>
        /// 2023-06-01.
        /// </summary>
        public static readonly string V2023_06_01 = "2023-06-01";

        /// <summary>
        /// 2023-05-01.
        /// </summary>
        public static readonly string V2023_05_01 = "2023-05-01";

        /// <summary>
        /// 2023-04-01.
        /// </summary>
        public static readonly string V2023_04_01 = "2023-04-01";

        /// <summary>
        /// 2023-03-01.
        /// </summary>
        public static readonly string V2023_03_01 = "2023-03-01";

        /// <summary>
        /// 2023-02-01.
        /// </summary>
        public static readonly string V2023_02_01 = "2023-02-01";

        /// <summary>
        /// 2023-01-01.
        /// </summary>
        public static readonly string V2023_01_01 = "2023-01-01";

        /// <summary>
        /// 2022-11-01.
        /// </summary>
        public static readonly string V2022_11_01 = "2022-11-01";

        /// <summary>
        /// 2022-09-01.
        /// </summary>
        public static readonly string V2022_09_01 = "2022-09-01";

        /// <summary>
        /// 2022-08-01.
        /// </summary>
        public static readonly string V2022_08_01 = "2022-08-01";

        /// <summary>
        /// 2022-07-01.
        /// </summary>
        public static readonly string V2022_07_01 = "2022-07-01";

        /// <summary>
        /// 2022-06-01.
        /// </summary>
        public static readonly string V2022_06_01 = "2022-06-01";

        /// <summary>
        /// 2022-04-01.
        /// </summary>
        public static readonly string V2022_04_01 = "2022-04-01";

        /// <summary>
        /// 2022-03-01.
        /// </summary>
        public static readonly string V2022_03_01 = "2022-03-01";

        /// <summary>
        /// 2022-02-01.
        /// </summary>
        public static readonly string V2022_02_01 = "2022-02-01";

        /// <summary>
        /// 2022-01-01.
        /// </summary>
        public static readonly string V2022_01_01 = "2022-01-01";

        /// <summary>
        /// 2021-10-01.
        /// </summary>
        public static readonly string V2021_10_01 = "2021-10-01";

        /// <summary>
        /// 2021-09-01.
        /// </summary>
        public static readonly string V2021_09_01 = "2021-09-01";

        /// <summary>
        /// 2021-08-01.
        /// </summary>
        public static readonly string V2021_08_01 = "2021-08-01";

        /// <summary>
        /// 2021-07-01.
        /// </summary>
        public static readonly string V2021_07_01 = "2021-07-01";

        /// <summary>
        /// 2021-05-01.
        /// </summary>
        public static readonly string V2021_05_01 = "2021-05-01";

        /// <summary>
        /// 2021-03-01.
        /// </summary>
        public static readonly string V2021_03_01 = "2021-03-01";

        /// <summary>
        /// 2021-02-01.
        /// </summary>
        public static readonly string V2021_02_01 = "2021-02-01";

        /// <summary>
        /// 2020-12-01.
        /// </summary>
        public static readonly string V2020_12_01 = "2020-12-01";

        /// <summary>
        /// 2020-11-01.
        /// </summary>
        public static readonly string V2020_11_01 = "2020-11-01";

        /// <summary>
        /// 2020-09-01.
        /// </summary>
        public static readonly string V2020_09_01 = "2020-09-01";

        /// <summary>
        /// 2020-07-01.
        /// </summary>
        public static readonly string V2020_07_01 = "2020-07-01";

        /// <summary>
        /// 2020-06-01.
        /// </summary>
        public static readonly string V2020_06_01 = "2020-06-01";

        /// <summary>
        /// 2020-04-01.
        /// </summary>
        public static readonly string V2020_04_01 = "2020-04-01";

        /// <summary>
        /// 2020-03-01.
        /// </summary>
        public static readonly string V2020_03_01 = "2020-03-01";

        /// <summary>
        /// 2020-02-01.
        /// </summary>
        public static readonly string V2020_02_01 = "2020-02-01";

        /// <summary>
        /// 2020-01-01.
        /// </summary>
        public static readonly string V2020_01_01 = "2020-01-01";

        /// <summary>
        /// 2019-11-01.
        /// </summary>
        public static readonly string V2019_11_01 = "2019-11-01";

        /// <summary>
        /// 2019-10-01.
        /// </summary>
        public static readonly string V2019_10_01 = "2019-10-01";

        /// <summary>
        /// 2019-08-01.
        /// </summary>
        public static readonly string V2019_08_01 = "2019-08-01";

        /// <summary>
        /// 2019-06-01.
        /// </summary>
        public static readonly string V2019_06_01 = "2019-06-01";

        /// <summary>
        /// 2019-04-01.
        /// </summary>
        public static readonly string V2019_04_01 = "2019-04-01";

        /// <summary>
        /// 2019-02-01.
        /// </summary>
        public static readonly string V2019_02_01 = "2019-02-01";

        /// <summary>
        /// 2018-03-31.
        /// </summary>
        public static readonly string V2018_03_31 = "2018-03-31";

        /// <summary>
        /// 2017-08-31.
        /// </summary>
        public static readonly string V2017_08_31 = "2017-08-31";
    }

    /// <summary>
    /// Creates a reference to an existing ContainerServiceAgentPool.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ContainerServiceAgentPool
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ContainerServiceAgentPool.</param>
    /// <returns>The existing ContainerServiceAgentPool resource.</returns>
    public static ContainerServiceAgentPool FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };

    /// <summary>
    /// Get the requirements for naming this ContainerServiceAgentPool resource.
    /// </summary>
    /// <returns>Naming requirements.</returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override ResourceNameRequirements GetResourceNameRequirements() =>
        new(minLength: 1, maxLength: 12, validCharacters: ResourceNameCharacters.LowercaseLetters | ResourceNameCharacters.Numbers);
}
