// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerRegistry;

/// <summary>
/// The authorization properties for accessing the source code repository.
/// </summary>
public partial class SourceCodeRepoAuthInfo : ProvisionableConstruct
{
    /// <summary>
    /// The type of Auth token.
    /// </summary>
    public BicepValue<SourceCodeRepoAuthTokenType> TokenType 
    {
        get { Initialize(); return _tokenType!; }
        set { Initialize(); _tokenType!.Assign(value); }
    }
    private BicepValue<SourceCodeRepoAuthTokenType>? _tokenType;

    /// <summary>
    /// The access token used to access the source control provider.
    /// </summary>
    public BicepValue<string> Token 
    {
        get { Initialize(); return _token!; }
        set { Initialize(); _token!.Assign(value); }
    }
    private BicepValue<string>? _token;

    /// <summary>
    /// The refresh token used to refresh the access token.
    /// </summary>
    public BicepValue<string> RefreshToken 
    {
        get { Initialize(); return _refreshToken!; }
        set { Initialize(); _refreshToken!.Assign(value); }
    }
    private BicepValue<string>? _refreshToken;

    /// <summary>
    /// The scope of the access token.
    /// </summary>
    public BicepValue<string> Scope 
    {
        get { Initialize(); return _scope!; }
        set { Initialize(); _scope!.Assign(value); }
    }
    private BicepValue<string>? _scope;

    /// <summary>
    /// Time in seconds that the token remains valid.
    /// </summary>
    public BicepValue<int> ExpireInSeconds 
    {
        get { Initialize(); return _expireInSeconds!; }
        set { Initialize(); _expireInSeconds!.Assign(value); }
    }
    private BicepValue<int>? _expireInSeconds;

    /// <summary>
    /// Creates a new SourceCodeRepoAuthInfo.
    /// </summary>
    public SourceCodeRepoAuthInfo()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of SourceCodeRepoAuthInfo.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _tokenType = DefineProperty<SourceCodeRepoAuthTokenType>("TokenType", ["tokenType"]);
        _token = DefineProperty<string>("Token", ["token"]);
        _refreshToken = DefineProperty<string>("RefreshToken", ["refreshToken"]);
        _scope = DefineProperty<string>("Scope", ["scope"]);
        _expireInSeconds = DefineProperty<int>("ExpireInSeconds", ["expiresIn"]);
    }
}
