// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerRegistry;

/// <summary>
/// Describes the credentials that will be used to access a custom registry
/// during a run.
/// </summary>
public partial class CustomRegistryCredentials : ProvisionableConstruct
{
    /// <summary>
    /// The username for logging into the custom registry.
    /// </summary>
    public ContainerRegistrySecretObject UserName 
    {
        get { Initialize(); return _userName!; }
        set { Initialize(); AssignOrReplace(ref _userName, value); }
    }
    private ContainerRegistrySecretObject? _userName;

    /// <summary>
    /// The password for logging into the custom registry. The password is a
    /// secret             object that allows multiple ways of providing the
    /// value for it.
    /// </summary>
    public ContainerRegistrySecretObject Password 
    {
        get { Initialize(); return _password!; }
        set { Initialize(); AssignOrReplace(ref _password, value); }
    }
    private ContainerRegistrySecretObject? _password;

    /// <summary>
    /// Indicates the managed identity assigned to the custom credential. If a
    /// user-assigned identity             this value is the Client ID. If a
    /// system-assigned identity, the value will be `system`. In
    /// the case of a system-assigned identity, the Client ID will
    /// be determined by the runner. This             identity may be used to
    /// authenticate to key vault to retrieve credentials or it may be the
    /// only             source of authentication used for accessing the
    /// registry.
    /// </summary>
    public BicepValue<string> Identity 
    {
        get { Initialize(); return _identity!; }
        set { Initialize(); _identity!.Assign(value); }
    }
    private BicepValue<string>? _identity;

    /// <summary>
    /// Creates a new CustomRegistryCredentials.
    /// </summary>
    public CustomRegistryCredentials()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of CustomRegistryCredentials.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _userName = DefineModelProperty<ContainerRegistrySecretObject>("UserName", ["userName"]);
        _password = DefineModelProperty<ContainerRegistrySecretObject>("Password", ["password"]);
        _identity = DefineProperty<string>("Identity", ["identity"]);
    }
}
