// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;

namespace Azure.Provisioning.ContainerRegistry;

/// <summary>
/// The content trust policy for a container registry.
/// </summary>
public partial class ContainerRegistryTrustPolicy : ProvisionableConstruct
{
    /// <summary>
    /// The type of trust policy.
    /// </summary>
    public BicepValue<ContainerRegistryTrustPolicyType> PolicyType 
    {
        get { Initialize(); return _policyType!; }
        set { Initialize(); _policyType!.Assign(value); }
    }
    private BicepValue<ContainerRegistryTrustPolicyType>? _policyType;

    /// <summary>
    /// The value that indicates whether the policy is enabled or not.
    /// </summary>
    public BicepValue<ContainerRegistryPolicyStatus> Status 
    {
        get { Initialize(); return _status!; }
        set { Initialize(); _status!.Assign(value); }
    }
    private BicepValue<ContainerRegistryPolicyStatus>? _status;

    /// <summary>
    /// Creates a new ContainerRegistryTrustPolicy.
    /// </summary>
    public ContainerRegistryTrustPolicy()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerRegistryTrustPolicy.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _policyType = DefineProperty<ContainerRegistryTrustPolicyType>("PolicyType", ["type"]);
        _status = DefineProperty<ContainerRegistryPolicyStatus>("Status", ["status"]);
    }
}
