// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerRegistry;

/// <summary>
/// The properties of the credentials that can be used for authenticating the
/// token.
/// </summary>
public partial class ContainerRegistryTokenCredentials : ProvisionableConstruct
{
    /// <summary>
    /// Gets the certificates.
    /// </summary>
    public BicepList<ContainerRegistryTokenCertificate> Certificates 
    {
        get { Initialize(); return _certificates!; }
        set { Initialize(); _certificates!.Assign(value); }
    }
    private BicepList<ContainerRegistryTokenCertificate>? _certificates;

    /// <summary>
    /// Gets the passwords.
    /// </summary>
    public BicepList<ContainerRegistryTokenPassword> Passwords 
    {
        get { Initialize(); return _passwords!; }
        set { Initialize(); _passwords!.Assign(value); }
    }
    private BicepList<ContainerRegistryTokenPassword>? _passwords;

    /// <summary>
    /// Creates a new ContainerRegistryTokenCredentials.
    /// </summary>
    public ContainerRegistryTokenCredentials()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerRegistryTokenCredentials.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _certificates = DefineListProperty<ContainerRegistryTokenCertificate>("Certificates", ["certificates"]);
        _passwords = DefineListProperty<ContainerRegistryTokenPassword>("Passwords", ["passwords"]);
    }
}
