// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerRegistry;

/// <summary>
/// The properties of a certificate used for authenticating a token.
/// </summary>
public partial class ContainerRegistryTokenCertificate : ProvisionableConstruct
{
    /// <summary>
    /// Gets or sets the name.
    /// </summary>
    public BicepValue<ContainerRegistryTokenCertificateName> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<ContainerRegistryTokenCertificateName>? _name;

    /// <summary>
    /// The expiry datetime of the certificate.
    /// </summary>
    public BicepValue<DateTimeOffset> ExpireOn 
    {
        get { Initialize(); return _expireOn!; }
        set { Initialize(); _expireOn!.Assign(value); }
    }
    private BicepValue<DateTimeOffset>? _expireOn;

    /// <summary>
    /// The thumbprint of the certificate.
    /// </summary>
    public BicepValue<string> Thumbprint 
    {
        get { Initialize(); return _thumbprint!; }
        set { Initialize(); _thumbprint!.Assign(value); }
    }
    private BicepValue<string>? _thumbprint;

    /// <summary>
    /// Base 64 encoded string of the public certificate1 in PEM format that
    /// will be used for authenticating the token.
    /// </summary>
    public BicepValue<string> EncodedPemCertificate 
    {
        get { Initialize(); return _encodedPemCertificate!; }
        set { Initialize(); _encodedPemCertificate!.Assign(value); }
    }
    private BicepValue<string>? _encodedPemCertificate;

    /// <summary>
    /// Creates a new ContainerRegistryTokenCertificate.
    /// </summary>
    public ContainerRegistryTokenCertificate()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerRegistryTokenCertificate.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<ContainerRegistryTokenCertificateName>("Name", ["name"]);
        _expireOn = DefineProperty<DateTimeOffset>("ExpireOn", ["expiry"]);
        _thumbprint = DefineProperty<string>("Thumbprint", ["thumbprint"]);
        _encodedPemCertificate = DefineProperty<string>("EncodedPemCertificate", ["encodedPemCertificate"]);
    }
}
