// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerRegistry;

/// <summary>
/// The properties of a overridable value that can be passed to a task template.
/// </summary>
public partial class ContainerRegistryTaskOverridableValue : ProvisionableConstruct
{
    /// <summary>
    /// The name of the overridable value.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The overridable value.
    /// </summary>
    public BicepValue<string> Value 
    {
        get { Initialize(); return _value!; }
        set { Initialize(); _value!.Assign(value); }
    }
    private BicepValue<string>? _value;

    /// <summary>
    /// Flag to indicate whether the value represents a secret or not.
    /// </summary>
    public BicepValue<bool> IsSecret 
    {
        get { Initialize(); return _isSecret!; }
        set { Initialize(); _isSecret!.Assign(value); }
    }
    private BicepValue<bool>? _isSecret;

    /// <summary>
    /// Creates a new ContainerRegistryTaskOverridableValue.
    /// </summary>
    public ContainerRegistryTaskOverridableValue()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerRegistryTaskOverridableValue.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"]);
        _value = DefineProperty<string>("Value", ["value"]);
        _isSecret = DefineProperty<bool>("IsSecret", ["isSecret"]);
    }
}
