// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerRegistry;

/// <summary>
/// The source trigger that caused a run.
/// </summary>
public partial class ContainerRegistrySourceTriggerDescriptor : ProvisionableConstruct
{
    /// <summary>
    /// The unique ID of the trigger.
    /// </summary>
    public BicepValue<Guid> Id 
    {
        get { Initialize(); return _id!; }
        set { Initialize(); _id!.Assign(value); }
    }
    private BicepValue<Guid>? _id;

    /// <summary>
    /// The event type of the trigger.
    /// </summary>
    public BicepValue<string> EventType 
    {
        get { Initialize(); return _eventType!; }
        set { Initialize(); _eventType!.Assign(value); }
    }
    private BicepValue<string>? _eventType;

    /// <summary>
    /// The unique ID that identifies a commit.
    /// </summary>
    public BicepValue<string> CommitId 
    {
        get { Initialize(); return _commitId!; }
        set { Initialize(); _commitId!.Assign(value); }
    }
    private BicepValue<string>? _commitId;

    /// <summary>
    /// The unique ID that identifies pull request.
    /// </summary>
    public BicepValue<string> PullRequestId 
    {
        get { Initialize(); return _pullRequestId!; }
        set { Initialize(); _pullRequestId!.Assign(value); }
    }
    private BicepValue<string>? _pullRequestId;

    /// <summary>
    /// The repository URL.
    /// </summary>
    public BicepValue<Uri> RepositoryUri 
    {
        get { Initialize(); return _repositoryUri!; }
        set { Initialize(); _repositoryUri!.Assign(value); }
    }
    private BicepValue<Uri>? _repositoryUri;

    /// <summary>
    /// The branch name in the repository.
    /// </summary>
    public BicepValue<string> BranchName 
    {
        get { Initialize(); return _branchName!; }
        set { Initialize(); _branchName!.Assign(value); }
    }
    private BicepValue<string>? _branchName;

    /// <summary>
    /// The source control provider type.
    /// </summary>
    public BicepValue<string> ProviderType 
    {
        get { Initialize(); return _providerType!; }
        set { Initialize(); _providerType!.Assign(value); }
    }
    private BicepValue<string>? _providerType;

    /// <summary>
    /// Creates a new ContainerRegistrySourceTriggerDescriptor.
    /// </summary>
    public ContainerRegistrySourceTriggerDescriptor()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerRegistrySourceTriggerDescriptor.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _id = DefineProperty<Guid>("Id", ["id"]);
        _eventType = DefineProperty<string>("EventType", ["eventType"]);
        _commitId = DefineProperty<string>("CommitId", ["commitId"]);
        _pullRequestId = DefineProperty<string>("PullRequestId", ["pullRequestId"]);
        _repositoryUri = DefineProperty<Uri>("RepositoryUri", ["repositoryUrl"]);
        _branchName = DefineProperty<string>("BranchName", ["branchName"]);
        _providerType = DefineProperty<string>("ProviderType", ["providerType"]);
    }
}
