// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;

namespace Azure.Provisioning.ContainerRegistry;

/// <summary>
/// The SKU of a container registry.
/// </summary>
public partial class ContainerRegistrySku : ProvisionableConstruct
{
    /// <summary>
    /// The SKU name of the container registry. Required for registry creation.
    /// </summary>
    public BicepValue<ContainerRegistrySkuName> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<ContainerRegistrySkuName>? _name;

    /// <summary>
    /// The SKU tier based on the SKU name.
    /// </summary>
    public BicepValue<ContainerRegistrySkuTier> Tier 
    {
        get { Initialize(); return _tier!; }
    }
    private BicepValue<ContainerRegistrySkuTier>? _tier;

    /// <summary>
    /// Creates a new ContainerRegistrySku.
    /// </summary>
    public ContainerRegistrySku()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerRegistrySku.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<ContainerRegistrySkuName>("Name", ["name"]);
        _tier = DefineProperty<ContainerRegistrySkuTier>("Tier", ["tier"], isOutput: true);
    }
}
