// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerRegistry;

/// <summary>
/// The retention policy for a container registry.
/// </summary>
public partial class ContainerRegistryRetentionPolicy : ProvisionableConstruct
{
    /// <summary>
    /// The number of days to retain an untagged manifest after which it gets
    /// purged.
    /// </summary>
    public BicepValue<int> Days 
    {
        get { Initialize(); return _days!; }
        set { Initialize(); _days!.Assign(value); }
    }
    private BicepValue<int>? _days;

    /// <summary>
    /// The timestamp when the policy was last updated.
    /// </summary>
    public BicepValue<DateTimeOffset> LastUpdatedOn 
    {
        get { Initialize(); return _lastUpdatedOn!; }
    }
    private BicepValue<DateTimeOffset>? _lastUpdatedOn;

    /// <summary>
    /// The value that indicates whether the policy is enabled or not.
    /// </summary>
    public BicepValue<ContainerRegistryPolicyStatus> Status 
    {
        get { Initialize(); return _status!; }
        set { Initialize(); _status!.Assign(value); }
    }
    private BicepValue<ContainerRegistryPolicyStatus>? _status;

    /// <summary>
    /// Creates a new ContainerRegistryRetentionPolicy.
    /// </summary>
    public ContainerRegistryRetentionPolicy()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerRegistryRetentionPolicy.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _days = DefineProperty<int>("Days", ["days"]);
        _lastUpdatedOn = DefineProperty<DateTimeOffset>("LastUpdatedOn", ["lastUpdatedTime"], isOutput: true);
        _status = DefineProperty<ContainerRegistryPolicyStatus>("Status", ["status"]);
    }
}
