// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerRegistry;

/// <summary>
/// The status of an Azure resource at the time the operation was called.
/// </summary>
public partial class ContainerRegistryResourceStatus : ProvisionableConstruct
{
    /// <summary>
    /// The short label for the status.
    /// </summary>
    public BicepValue<string> DisplayStatus 
    {
        get { Initialize(); return _displayStatus!; }
    }
    private BicepValue<string>? _displayStatus;

    /// <summary>
    /// The detailed message for the status, including alerts and error
    /// messages.
    /// </summary>
    public BicepValue<string> Message 
    {
        get { Initialize(); return _message!; }
    }
    private BicepValue<string>? _message;

    /// <summary>
    /// The timestamp when the status was changed to the current value.
    /// </summary>
    public BicepValue<DateTimeOffset> Timestamp 
    {
        get { Initialize(); return _timestamp!; }
    }
    private BicepValue<DateTimeOffset>? _timestamp;

    /// <summary>
    /// Creates a new ContainerRegistryResourceStatus.
    /// </summary>
    public ContainerRegistryResourceStatus()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerRegistryResourceStatus.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _displayStatus = DefineProperty<string>("DisplayStatus", ["displayStatus"], isOutput: true);
        _message = DefineProperty<string>("Message", ["message"], isOutput: true);
        _timestamp = DefineProperty<DateTimeOffset>("Timestamp", ["timestamp"], isOutput: true);
    }
}
