// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerRegistry;

/// <summary>
/// The state of a private link service connection.
/// </summary>
public partial class ContainerRegistryPrivateLinkServiceConnectionState : ProvisionableConstruct
{
    /// <summary>
    /// The private link service connection status.
    /// </summary>
    public BicepValue<ContainerRegistryPrivateLinkServiceConnectionStatus> Status 
    {
        get { Initialize(); return _status!; }
        set { Initialize(); _status!.Assign(value); }
    }
    private BicepValue<ContainerRegistryPrivateLinkServiceConnectionStatus>? _status;

    /// <summary>
    /// The description for connection status. For example if connection is
    /// rejected it can indicate reason for rejection.
    /// </summary>
    public BicepValue<string> Description 
    {
        get { Initialize(); return _description!; }
        set { Initialize(); _description!.Assign(value); }
    }
    private BicepValue<string>? _description;

    /// <summary>
    /// A message indicating if changes on the service provider require any
    /// updates on the consumer.
    /// </summary>
    public BicepValue<ActionsRequiredForPrivateLinkServiceConsumer> ActionsRequired 
    {
        get { Initialize(); return _actionsRequired!; }
        set { Initialize(); _actionsRequired!.Assign(value); }
    }
    private BicepValue<ActionsRequiredForPrivateLinkServiceConsumer>? _actionsRequired;

    /// <summary>
    /// Creates a new ContainerRegistryPrivateLinkServiceConnectionState.
    /// </summary>
    public ContainerRegistryPrivateLinkServiceConnectionState()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerRegistryPrivateLinkServiceConnectionState.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _status = DefineProperty<ContainerRegistryPrivateLinkServiceConnectionStatus>("Status", ["status"]);
        _description = DefineProperty<string>("Description", ["description"]);
        _actionsRequired = DefineProperty<ActionsRequiredForPrivateLinkServiceConsumer>("ActionsRequired", ["actionsRequired"]);
    }
}
