// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerRegistry;

/// <summary>
/// The policies for a container registry.
/// </summary>
public partial class ContainerRegistryPolicies : ProvisionableConstruct
{
    /// <summary>
    /// The value that indicates whether the policy is enabled or not.
    /// </summary>
    public BicepValue<ContainerRegistryPolicyStatus> QuarantineStatus 
    {
        get { Initialize(); return _quarantineStatus!; }
        set { Initialize(); _quarantineStatus!.Assign(value); }
    }
    private BicepValue<ContainerRegistryPolicyStatus>? _quarantineStatus;

    /// <summary>
    /// The content trust policy for a container registry.
    /// </summary>
    public ContainerRegistryTrustPolicy TrustPolicy 
    {
        get { Initialize(); return _trustPolicy!; }
        set { Initialize(); AssignOrReplace(ref _trustPolicy, value); }
    }
    private ContainerRegistryTrustPolicy? _trustPolicy;

    /// <summary>
    /// The retention policy for a container registry.
    /// </summary>
    public ContainerRegistryRetentionPolicy RetentionPolicy 
    {
        get { Initialize(); return _retentionPolicy!; }
        set { Initialize(); AssignOrReplace(ref _retentionPolicy, value); }
    }
    private ContainerRegistryRetentionPolicy? _retentionPolicy;

    /// <summary>
    /// The value that indicates whether the policy is enabled or not.
    /// </summary>
    public BicepValue<ContainerRegistryExportPolicyStatus> ExportStatus 
    {
        get { Initialize(); return _exportStatus!; }
        set { Initialize(); _exportStatus!.Assign(value); }
    }
    private BicepValue<ContainerRegistryExportPolicyStatus>? _exportStatus;

    /// <summary>
    /// Creates a new ContainerRegistryPolicies.
    /// </summary>
    public ContainerRegistryPolicies()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerRegistryPolicies.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _quarantineStatus = DefineProperty<ContainerRegistryPolicyStatus>("QuarantineStatus", ["quarantinePolicy", "status"]);
        _trustPolicy = DefineModelProperty<ContainerRegistryTrustPolicy>("TrustPolicy", ["trustPolicy"]);
        _retentionPolicy = DefineModelProperty<ContainerRegistryRetentionPolicy>("RetentionPolicy", ["retentionPolicy"]);
        _exportStatus = DefineProperty<ContainerRegistryExportPolicyStatus>("ExportStatus", ["exportPolicy", "status"]);
    }
}
