// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerRegistry;

/// <summary>
/// The network rule set for a container registry.
/// </summary>
public partial class ContainerRegistryNetworkRuleSet : ProvisionableConstruct
{
    /// <summary>
    /// The default action of allow or deny when no other rules match.
    /// </summary>
    public BicepValue<ContainerRegistryNetworkRuleDefaultAction> DefaultAction 
    {
        get { Initialize(); return _defaultAction!; }
        set { Initialize(); _defaultAction!.Assign(value); }
    }
    private BicepValue<ContainerRegistryNetworkRuleDefaultAction>? _defaultAction;

    /// <summary>
    /// The IP ACL rules.
    /// </summary>
    public BicepList<ContainerRegistryIPRule> IPRules 
    {
        get { Initialize(); return _iPRules!; }
        set { Initialize(); _iPRules!.Assign(value); }
    }
    private BicepList<ContainerRegistryIPRule>? _iPRules;

    /// <summary>
    /// Creates a new ContainerRegistryNetworkRuleSet.
    /// </summary>
    public ContainerRegistryNetworkRuleSet()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerRegistryNetworkRuleSet.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _defaultAction = DefineProperty<ContainerRegistryNetworkRuleDefaultAction>("DefaultAction", ["defaultAction"]);
        _iPRules = DefineListProperty<ContainerRegistryIPRule>("IPRules", ["ipRules"]);
    }
}
