// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerRegistry;

/// <summary>
/// The request parameters for a scheduling run against a task file.
/// </summary>
public partial class ContainerRegistryFileTaskRunContent : ContainerRegistryRunContent
{
    /// <summary>
    /// The template/definition file path relative to the source.
    /// </summary>
    public BicepValue<string> TaskFilePath 
    {
        get { Initialize(); return _taskFilePath!; }
        set { Initialize(); _taskFilePath!.Assign(value); }
    }
    private BicepValue<string>? _taskFilePath;

    /// <summary>
    /// The values/parameters file path relative to the source.
    /// </summary>
    public BicepValue<string> ValuesFilePath 
    {
        get { Initialize(); return _valuesFilePath!; }
        set { Initialize(); _valuesFilePath!.Assign(value); }
    }
    private BicepValue<string>? _valuesFilePath;

    /// <summary>
    /// The collection of overridable values that can be passed when running a
    /// task.
    /// </summary>
    public BicepList<ContainerRegistryTaskOverridableValue> Values 
    {
        get { Initialize(); return _values!; }
        set { Initialize(); _values!.Assign(value); }
    }
    private BicepList<ContainerRegistryTaskOverridableValue>? _values;

    /// <summary>
    /// Run timeout in seconds.
    /// </summary>
    public BicepValue<int> TimeoutInSeconds 
    {
        get { Initialize(); return _timeoutInSeconds!; }
        set { Initialize(); _timeoutInSeconds!.Assign(value); }
    }
    private BicepValue<int>? _timeoutInSeconds;

    /// <summary>
    /// The platform properties against which the run has to happen.
    /// </summary>
    public ContainerRegistryPlatformProperties Platform 
    {
        get { Initialize(); return _platform!; }
        set { Initialize(); AssignOrReplace(ref _platform, value); }
    }
    private ContainerRegistryPlatformProperties? _platform;

    /// <summary>
    /// The CPU configuration in terms of number of cores required for the run.
    /// </summary>
    public BicepValue<int> AgentCpu 
    {
        get { Initialize(); return _agentCpu!; }
        set { Initialize(); _agentCpu!.Assign(value); }
    }
    private BicepValue<int>? _agentCpu;

    /// <summary>
    /// The URL(absolute or relative) of the source context. It can be an URL
    /// to a tar or git repository.             If it is relative URL, the
    /// relative path should be obtained from calling listBuildSourceUploadUrl
    /// API.
    /// </summary>
    public BicepValue<string> SourceLocation 
    {
        get { Initialize(); return _sourceLocation!; }
        set { Initialize(); _sourceLocation!.Assign(value); }
    }
    private BicepValue<string>? _sourceLocation;

    /// <summary>
    /// The properties that describes a set of credentials that will be used
    /// when this run is invoked.
    /// </summary>
    public ContainerRegistryCredentials Credentials 
    {
        get { Initialize(); return _credentials!; }
        set { Initialize(); AssignOrReplace(ref _credentials, value); }
    }
    private ContainerRegistryCredentials? _credentials;

    /// <summary>
    /// Creates a new ContainerRegistryFileTaskRunContent.
    /// </summary>
    public ContainerRegistryFileTaskRunContent() : base()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerRegistryFileTaskRunContent.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        DefineProperty<string>("type", ["type"], defaultValue: "FileTaskRunRequest");
        _taskFilePath = DefineProperty<string>("TaskFilePath", ["taskFilePath"]);
        _valuesFilePath = DefineProperty<string>("ValuesFilePath", ["valuesFilePath"]);
        _values = DefineListProperty<ContainerRegistryTaskOverridableValue>("Values", ["values"]);
        _timeoutInSeconds = DefineProperty<int>("TimeoutInSeconds", ["timeout"]);
        _platform = DefineModelProperty<ContainerRegistryPlatformProperties>("Platform", ["platform"]);
        _agentCpu = DefineProperty<int>("AgentCpu", ["agentConfiguration", "cpu"]);
        _sourceLocation = DefineProperty<string>("SourceLocation", ["sourceLocation"]);
        _credentials = DefineModelProperty<ContainerRegistryCredentials>("Credentials", ["credentials"]);
    }
}
