// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerRegistry;

/// <summary>
/// The ContainerRegistryEncryption.
/// </summary>
public partial class ContainerRegistryEncryption : ProvisionableConstruct
{
    /// <summary>
    /// Indicates whether or not the encryption is enabled for container
    /// registry.
    /// </summary>
    public BicepValue<ContainerRegistryEncryptionStatus> Status 
    {
        get { Initialize(); return _status!; }
        set { Initialize(); _status!.Assign(value); }
    }
    private BicepValue<ContainerRegistryEncryptionStatus>? _status;

    /// <summary>
    /// Key vault properties.
    /// </summary>
    public ContainerRegistryKeyVaultProperties KeyVaultProperties 
    {
        get { Initialize(); return _keyVaultProperties!; }
        set { Initialize(); AssignOrReplace(ref _keyVaultProperties, value); }
    }
    private ContainerRegistryKeyVaultProperties? _keyVaultProperties;

    /// <summary>
    /// Creates a new ContainerRegistryEncryption.
    /// </summary>
    public ContainerRegistryEncryption()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerRegistryEncryption.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _status = DefineProperty<ContainerRegistryEncryptionStatus>("Status", ["status"]);
        _keyVaultProperties = DefineModelProperty<ContainerRegistryKeyVaultProperties>("KeyVaultProperties", ["keyVaultProperties"]);
    }
}
