// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerRegistry;

/// <summary>
/// The properties of a encoded task step.
/// </summary>
public partial class ContainerRegistryEncodedTaskStep : ContainerRegistryTaskStepProperties
{
    /// <summary>
    /// Base64 encoded value of the template/definition file content.
    /// </summary>
    public BicepValue<string> EncodedTaskContent 
    {
        get { Initialize(); return _encodedTaskContent!; }
        set { Initialize(); _encodedTaskContent!.Assign(value); }
    }
    private BicepValue<string>? _encodedTaskContent;

    /// <summary>
    /// Base64 encoded value of the parameters/values file content.
    /// </summary>
    public BicepValue<string> EncodedValuesContent 
    {
        get { Initialize(); return _encodedValuesContent!; }
        set { Initialize(); _encodedValuesContent!.Assign(value); }
    }
    private BicepValue<string>? _encodedValuesContent;

    /// <summary>
    /// The collection of overridable values that can be passed when running a
    /// task.
    /// </summary>
    public BicepList<ContainerRegistryTaskOverridableValue> Values 
    {
        get { Initialize(); return _values!; }
        set { Initialize(); _values!.Assign(value); }
    }
    private BicepList<ContainerRegistryTaskOverridableValue>? _values;

    /// <summary>
    /// Creates a new ContainerRegistryEncodedTaskStep.
    /// </summary>
    public ContainerRegistryEncodedTaskStep() : base()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerRegistryEncodedTaskStep.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        DefineProperty<string>("type", ["type"], defaultValue: "EncodedTask");
        _encodedTaskContent = DefineProperty<string>("EncodedTaskContent", ["encodedTaskContent"]);
        _encodedValuesContent = DefineProperty<string>("EncodedValuesContent", ["encodedValuesContent"]);
        _values = DefineListProperty<ContainerRegistryTaskOverridableValue>("Values", ["values"]);
    }
}
