// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerRegistry;

/// <summary>
/// The Docker build step.
/// </summary>
public partial class ContainerRegistryDockerBuildStep : ContainerRegistryTaskStepProperties
{
    /// <summary>
    /// The fully qualified image names including the repository and tag.
    /// </summary>
    public BicepList<string> ImageNames 
    {
        get { Initialize(); return _imageNames!; }
        set { Initialize(); _imageNames!.Assign(value); }
    }
    private BicepList<string>? _imageNames;

    /// <summary>
    /// The value of this property indicates whether the image built should be
    /// pushed to the registry or not.
    /// </summary>
    public BicepValue<bool> IsPushEnabled 
    {
        get { Initialize(); return _isPushEnabled!; }
        set { Initialize(); _isPushEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isPushEnabled;

    /// <summary>
    /// The value of this property indicates whether the image cache is enabled
    /// or not.
    /// </summary>
    public BicepValue<bool> NoCache 
    {
        get { Initialize(); return _noCache!; }
        set { Initialize(); _noCache!.Assign(value); }
    }
    private BicepValue<bool>? _noCache;

    /// <summary>
    /// The Docker file path relative to the source context.
    /// </summary>
    public BicepValue<string> DockerFilePath 
    {
        get { Initialize(); return _dockerFilePath!; }
        set { Initialize(); _dockerFilePath!.Assign(value); }
    }
    private BicepValue<string>? _dockerFilePath;

    /// <summary>
    /// The name of the target build stage for the docker build.
    /// </summary>
    public BicepValue<string> Target 
    {
        get { Initialize(); return _target!; }
        set { Initialize(); _target!.Assign(value); }
    }
    private BicepValue<string>? _target;

    /// <summary>
    /// The collection of override arguments to be used when executing this
    /// build step.
    /// </summary>
    public BicepList<ContainerRegistryRunArgument> Arguments 
    {
        get { Initialize(); return _arguments!; }
        set { Initialize(); _arguments!.Assign(value); }
    }
    private BicepList<ContainerRegistryRunArgument>? _arguments;

    /// <summary>
    /// Creates a new ContainerRegistryDockerBuildStep.
    /// </summary>
    public ContainerRegistryDockerBuildStep() : base()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerRegistryDockerBuildStep.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        DefineProperty<string>("type", ["type"], defaultValue: "Docker");
        _imageNames = DefineListProperty<string>("ImageNames", ["imageNames"]);
        _isPushEnabled = DefineProperty<bool>("IsPushEnabled", ["isPushEnabled"]);
        _noCache = DefineProperty<bool>("NoCache", ["noCache"]);
        _dockerFilePath = DefineProperty<string>("DockerFilePath", ["dockerFilePath"]);
        _target = DefineProperty<string>("Target", ["target"]);
        _arguments = DefineListProperty<ContainerRegistryRunArgument>("Arguments", ["arguments"]);
    }
}
