// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerRegistry;

/// <summary>
/// The parameters for a docker quick build.
/// </summary>
public partial class ContainerRegistryDockerBuildContent : ContainerRegistryRunContent
{
    /// <summary>
    /// The fully qualified image names including the repository and tag.
    /// </summary>
    public BicepList<string> ImageNames 
    {
        get { Initialize(); return _imageNames!; }
        set { Initialize(); _imageNames!.Assign(value); }
    }
    private BicepList<string>? _imageNames;

    /// <summary>
    /// The value of this property indicates whether the image built should be
    /// pushed to the registry or not.
    /// </summary>
    public BicepValue<bool> IsPushEnabled 
    {
        get { Initialize(); return _isPushEnabled!; }
        set { Initialize(); _isPushEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isPushEnabled;

    /// <summary>
    /// The value of this property indicates whether the image cache is enabled
    /// or not.
    /// </summary>
    public BicepValue<bool> NoCache 
    {
        get { Initialize(); return _noCache!; }
        set { Initialize(); _noCache!.Assign(value); }
    }
    private BicepValue<bool>? _noCache;

    /// <summary>
    /// The Docker file path relative to the source location.
    /// </summary>
    public BicepValue<string> DockerFilePath 
    {
        get { Initialize(); return _dockerFilePath!; }
        set { Initialize(); _dockerFilePath!.Assign(value); }
    }
    private BicepValue<string>? _dockerFilePath;

    /// <summary>
    /// The name of the target build stage for the docker build.
    /// </summary>
    public BicepValue<string> Target 
    {
        get { Initialize(); return _target!; }
        set { Initialize(); _target!.Assign(value); }
    }
    private BicepValue<string>? _target;

    /// <summary>
    /// The collection of override arguments to be used when executing the run.
    /// </summary>
    public BicepList<ContainerRegistryRunArgument> Arguments 
    {
        get { Initialize(); return _arguments!; }
        set { Initialize(); _arguments!.Assign(value); }
    }
    private BicepList<ContainerRegistryRunArgument>? _arguments;

    /// <summary>
    /// Run timeout in seconds.
    /// </summary>
    public BicepValue<int> TimeoutInSeconds 
    {
        get { Initialize(); return _timeoutInSeconds!; }
        set { Initialize(); _timeoutInSeconds!.Assign(value); }
    }
    private BicepValue<int>? _timeoutInSeconds;

    /// <summary>
    /// The platform properties against which the run has to happen.
    /// </summary>
    public ContainerRegistryPlatformProperties Platform 
    {
        get { Initialize(); return _platform!; }
        set { Initialize(); AssignOrReplace(ref _platform, value); }
    }
    private ContainerRegistryPlatformProperties? _platform;

    /// <summary>
    /// The CPU configuration in terms of number of cores required for the run.
    /// </summary>
    public BicepValue<int> AgentCpu 
    {
        get { Initialize(); return _agentCpu!; }
        set { Initialize(); _agentCpu!.Assign(value); }
    }
    private BicepValue<int>? _agentCpu;

    /// <summary>
    /// The URL(absolute or relative) of the source context. It can be an URL
    /// to a tar or git repository.             If it is relative URL, the
    /// relative path should be obtained from calling listBuildSourceUploadUrl
    /// API.
    /// </summary>
    public BicepValue<string> SourceLocation 
    {
        get { Initialize(); return _sourceLocation!; }
        set { Initialize(); _sourceLocation!.Assign(value); }
    }
    private BicepValue<string>? _sourceLocation;

    /// <summary>
    /// The properties that describes a set of credentials that will be used
    /// when this run is invoked.
    /// </summary>
    public ContainerRegistryCredentials Credentials 
    {
        get { Initialize(); return _credentials!; }
        set { Initialize(); AssignOrReplace(ref _credentials, value); }
    }
    private ContainerRegistryCredentials? _credentials;

    /// <summary>
    /// Creates a new ContainerRegistryDockerBuildContent.
    /// </summary>
    public ContainerRegistryDockerBuildContent() : base()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerRegistryDockerBuildContent.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        DefineProperty<string>("type", ["type"], defaultValue: "DockerBuildRequest");
        _imageNames = DefineListProperty<string>("ImageNames", ["imageNames"]);
        _isPushEnabled = DefineProperty<bool>("IsPushEnabled", ["isPushEnabled"]);
        _noCache = DefineProperty<bool>("NoCache", ["noCache"]);
        _dockerFilePath = DefineProperty<string>("DockerFilePath", ["dockerFilePath"]);
        _target = DefineProperty<string>("Target", ["target"]);
        _arguments = DefineListProperty<ContainerRegistryRunArgument>("Arguments", ["arguments"]);
        _timeoutInSeconds = DefineProperty<int>("TimeoutInSeconds", ["timeout"]);
        _platform = DefineModelProperty<ContainerRegistryPlatformProperties>("Platform", ["platform"]);
        _agentCpu = DefineProperty<int>("AgentCpu", ["agentConfiguration", "cpu"]);
        _sourceLocation = DefineProperty<string>("SourceLocation", ["sourceLocation"]);
        _credentials = DefineModelProperty<ContainerRegistryCredentials>("Credentials", ["credentials"]);
    }
}
