// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerRegistry;

/// <summary>
/// The parameters that describes a set of credentials that will be used when a
/// run is invoked.
/// </summary>
public partial class ContainerRegistryCredentials : ProvisionableConstruct
{
    /// <summary>
    /// The authentication mode which determines the source registry login
    /// scope. The credentials for the source registry             will be
    /// generated using the given scope. These credentials will be used to
    /// login to             the source registry during the run.
    /// </summary>
    public BicepValue<SourceRegistryLoginMode> SourceRegistryLoginMode 
    {
        get { Initialize(); return _sourceRegistryLoginMode!; }
        set { Initialize(); _sourceRegistryLoginMode!.Assign(value); }
    }
    private BicepValue<SourceRegistryLoginMode>? _sourceRegistryLoginMode;

    /// <summary>
    /// Describes the credential parameters for accessing other custom
    /// registries. The key             for the dictionary item will be the
    /// registry login server (myregistry.azurecr.io) and             the
    /// value of the item will be the registry credentials for accessing the
    /// registry.
    /// </summary>
    public BicepDictionary<CustomRegistryCredentials> CustomRegistries 
    {
        get { Initialize(); return _customRegistries!; }
        set { Initialize(); _customRegistries!.Assign(value); }
    }
    private BicepDictionary<CustomRegistryCredentials>? _customRegistries;

    /// <summary>
    /// Creates a new ContainerRegistryCredentials.
    /// </summary>
    public ContainerRegistryCredentials()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerRegistryCredentials.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _sourceRegistryLoginMode = DefineProperty<SourceRegistryLoginMode>("SourceRegistryLoginMode", ["sourceRegistry", "loginMode"]);
        _customRegistries = DefineDictionaryProperty<CustomRegistryCredentials>("CustomRegistries", ["customRegistries"]);
    }
}
