// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerRegistry;

/// <summary>
/// The trigger based on base image dependency.
/// </summary>
public partial class ContainerRegistryBaseImageTrigger : ProvisionableConstruct
{
    /// <summary>
    /// The type of the auto trigger for base image dependency updates.
    /// </summary>
    public BicepValue<ContainerRegistryBaseImageTriggerType> BaseImageTriggerType 
    {
        get { Initialize(); return _baseImageTriggerType!; }
        set { Initialize(); _baseImageTriggerType!.Assign(value); }
    }
    private BicepValue<ContainerRegistryBaseImageTriggerType>? _baseImageTriggerType;

    /// <summary>
    /// The endpoint URL for receiving update triggers.
    /// </summary>
    public BicepValue<string> UpdateTriggerEndpoint 
    {
        get { Initialize(); return _updateTriggerEndpoint!; }
        set { Initialize(); _updateTriggerEndpoint!.Assign(value); }
    }
    private BicepValue<string>? _updateTriggerEndpoint;

    /// <summary>
    /// Type of Payload body for Base image update triggers.
    /// </summary>
    public BicepValue<ContainerRegistryUpdateTriggerPayloadType> UpdateTriggerPayloadType 
    {
        get { Initialize(); return _updateTriggerPayloadType!; }
        set { Initialize(); _updateTriggerPayloadType!.Assign(value); }
    }
    private BicepValue<ContainerRegistryUpdateTriggerPayloadType>? _updateTriggerPayloadType;

    /// <summary>
    /// The current status of trigger.
    /// </summary>
    public BicepValue<ContainerRegistryTriggerStatus> Status 
    {
        get { Initialize(); return _status!; }
        set { Initialize(); _status!.Assign(value); }
    }
    private BicepValue<ContainerRegistryTriggerStatus>? _status;

    /// <summary>
    /// The name of the trigger.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Creates a new ContainerRegistryBaseImageTrigger.
    /// </summary>
    public ContainerRegistryBaseImageTrigger()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerRegistryBaseImageTrigger.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _baseImageTriggerType = DefineProperty<ContainerRegistryBaseImageTriggerType>("BaseImageTriggerType", ["baseImageTriggerType"]);
        _updateTriggerEndpoint = DefineProperty<string>("UpdateTriggerEndpoint", ["updateTriggerEndpoint"]);
        _updateTriggerPayloadType = DefineProperty<ContainerRegistryUpdateTriggerPayloadType>("UpdateTriggerPayloadType", ["updateTriggerPayloadType"]);
        _status = DefineProperty<ContainerRegistryTriggerStatus>("Status", ["status"]);
        _name = DefineProperty<string>("Name", ["name"]);
    }
}
