// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerRegistry;

/// <summary>
/// Properties that describe a base image dependency.
/// </summary>
public partial class ContainerRegistryBaseImageDependency : ProvisionableConstruct
{
    /// <summary>
    /// The type of the base image dependency.
    /// </summary>
    public BicepValue<ContainerRegistryBaseImageDependencyType> DependencyType 
    {
        get { Initialize(); return _dependencyType!; }
    }
    private BicepValue<ContainerRegistryBaseImageDependencyType>? _dependencyType;

    /// <summary>
    /// The registry login server.
    /// </summary>
    public BicepValue<string> Registry 
    {
        get { Initialize(); return _registry!; }
    }
    private BicepValue<string>? _registry;

    /// <summary>
    /// The repository name.
    /// </summary>
    public BicepValue<string> Repository 
    {
        get { Initialize(); return _repository!; }
    }
    private BicepValue<string>? _repository;

    /// <summary>
    /// The tag name.
    /// </summary>
    public BicepValue<string> Tag 
    {
        get { Initialize(); return _tag!; }
    }
    private BicepValue<string>? _tag;

    /// <summary>
    /// The sha256-based digest of the image manifest.
    /// </summary>
    public BicepValue<string> Digest 
    {
        get { Initialize(); return _digest!; }
    }
    private BicepValue<string>? _digest;

    /// <summary>
    /// Creates a new ContainerRegistryBaseImageDependency.
    /// </summary>
    public ContainerRegistryBaseImageDependency()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerRegistryBaseImageDependency.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _dependencyType = DefineProperty<ContainerRegistryBaseImageDependencyType>("DependencyType", ["type"], isOutput: true);
        _registry = DefineProperty<string>("Registry", ["registry"], isOutput: true);
        _repository = DefineProperty<string>("Repository", ["repository"], isOutput: true);
        _tag = DefineProperty<string>("Tag", ["tag"], isOutput: true);
        _digest = DefineProperty<string>("Digest", ["digest"], isOutput: true);
    }
}
