// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;
using System.ComponentModel;

namespace Azure.Provisioning.ContainerRegistry;

/// <summary>
/// ContainerRegistryWebhook.
/// </summary>
public partial class ContainerRegistryWebhook : ProvisionableResource
{
    /// <summary>
    /// The name of the webhook.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The location of the webhook. This cannot be changed after the resource
    /// is created.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
        set { Initialize(); _location!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// The list of actions that trigger the webhook to post notifications.
    /// </summary>
    public BicepList<ContainerRegistryWebhookAction> Actions 
    {
        get { Initialize(); return _actions!; }
        set { Initialize(); _actions!.Assign(value); }
    }
    private BicepList<ContainerRegistryWebhookAction>? _actions;

    /// <summary>
    /// Custom headers that will be added to the webhook notifications.
    /// </summary>
    public BicepDictionary<string> CustomHeaders 
    {
        get { Initialize(); return _customHeaders!; }
        set { Initialize(); _customHeaders!.Assign(value); }
    }
    private BicepDictionary<string>? _customHeaders;

    /// <summary>
    /// The scope of repositories where the event can be triggered. For
    /// example, &apos;foo:*&apos; means events for all tags under repository
    /// &apos;foo&apos;. &apos;foo:bar&apos; means events for
    /// &apos;foo:bar&apos; only. &apos;foo&apos; is equivalent to
    /// &apos;foo:latest&apos;. Empty means all events.
    /// </summary>
    public BicepValue<string> Scope 
    {
        get { Initialize(); return _scope!; }
        set { Initialize(); _scope!.Assign(value); }
    }
    private BicepValue<string>? _scope;

    /// <summary>
    /// The service URI for the webhook to post notifications.
    /// </summary>
    public BicepValue<Uri> ServiceUri 
    {
        get { Initialize(); return _serviceUri!; }
        set { Initialize(); _serviceUri!.Assign(value); }
    }
    private BicepValue<Uri>? _serviceUri;

    /// <summary>
    /// The status of the webhook at the time the operation was called.
    /// </summary>
    public BicepValue<ContainerRegistryWebhookStatus> Status 
    {
        get { Initialize(); return _status!; }
        set { Initialize(); _status!.Assign(value); }
    }
    private BicepValue<ContainerRegistryWebhookStatus>? _status;

    /// <summary>
    /// The tags for the webhook.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// The provisioning state of the webhook at the time the operation was
    /// called.
    /// </summary>
    public BicepValue<ContainerRegistryProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<ContainerRegistryProvisioningState>? _provisioningState;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent ContainerRegistryService.
    /// </summary>
    public ContainerRegistryService? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<ContainerRegistryService>? _parent;

    /// <summary>
    /// Creates a new ContainerRegistryWebhook.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ContainerRegistryWebhook resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ContainerRegistryWebhook.</param>
    public ContainerRegistryWebhook(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.ContainerRegistry/registries/webhooks", resourceVersion ?? "2023-07-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerRegistryWebhook.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isRequired: true);
        _actions = DefineListProperty<ContainerRegistryWebhookAction>("Actions", ["properties", "actions"]);
        _customHeaders = DefineDictionaryProperty<string>("CustomHeaders", ["properties", "customHeaders"]);
        _scope = DefineProperty<string>("Scope", ["properties", "scope"]);
        _serviceUri = DefineProperty<Uri>("ServiceUri", ["properties", "serviceUri"]);
        _status = DefineProperty<ContainerRegistryWebhookStatus>("Status", ["properties", "status"]);
        _tags = DefineDictionaryProperty<string>("Tags", ["tags"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _provisioningState = DefineProperty<ContainerRegistryProvisioningState>("ProvisioningState", ["properties", "provisioningState"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<ContainerRegistryService>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported ContainerRegistryWebhook resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2023-07-01.
        /// </summary>
        public static readonly string V2023_07_01 = "2023-07-01";

        /// <summary>
        /// 2022-12-01.
        /// </summary>
        public static readonly string V2022_12_01 = "2022-12-01";

        /// <summary>
        /// 2021-09-01.
        /// </summary>
        public static readonly string V2021_09_01 = "2021-09-01";

        /// <summary>
        /// 2019-05-01.
        /// </summary>
        public static readonly string V2019_05_01 = "2019-05-01";

        /// <summary>
        /// 2017-10-01.
        /// </summary>
        public static readonly string V2017_10_01 = "2017-10-01";
    }

    /// <summary>
    /// Creates a reference to an existing ContainerRegistryWebhook.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ContainerRegistryWebhook resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ContainerRegistryWebhook.</param>
    /// <returns>The existing ContainerRegistryWebhook resource.</returns>
    public static ContainerRegistryWebhook FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };

    /// <summary>
    /// Get the requirements for naming this ContainerRegistryWebhook resource.
    /// </summary>
    /// <returns>Naming requirements.</returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override ResourceNameRequirements GetResourceNameRequirements() =>
        new(minLength: 5, maxLength: 50, validCharacters: ResourceNameCharacters.LowercaseLetters | ResourceNameCharacters.UppercaseLetters | ResourceNameCharacters.Numbers);
}
