// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.ContainerRegistry;

/// <summary>
/// ContainerRegistryTaskRun.
/// </summary>
public partial class ContainerRegistryTaskRun : ProvisionableResource
{
    /// <summary>
    /// The name of the task run.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// How the run should be forced to rerun even if the run request
    /// configuration has not changed.
    /// </summary>
    public BicepValue<string> ForceUpdateTag 
    {
        get { Initialize(); return _forceUpdateTag!; }
        set { Initialize(); _forceUpdateTag!.Assign(value); }
    }
    private BicepValue<string>? _forceUpdateTag;

    /// <summary>
    /// Identity for the resource.
    /// </summary>
    public ManagedServiceIdentity Identity 
    {
        get { Initialize(); return _identity!; }
        set { Initialize(); AssignOrReplace(ref _identity, value); }
    }
    private ManagedServiceIdentity? _identity;

    /// <summary>
    /// The location of the resource.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
        set { Initialize(); _location!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// The request (parameters) for the run             Please note
    /// Azure.ResourceManager.ContainerRegistry.Models.ContainerRegistryRunContent
    /// is the base class. According to the scenario, a derived class of the
    /// base class might need to be assigned here, or this property needs to
    /// be casted to one of the possible derived classes.             The
    /// available derived classes include
    /// Azure.ResourceManager.ContainerRegistry.Models.ContainerRegistryDockerBuildContent,
    /// Azure.ResourceManager.ContainerRegistry.Models.ContainerRegistryEncodedTaskRunContent,
    /// Azure.ResourceManager.ContainerRegistry.Models.ContainerRegistryFileTaskRunContent
    /// and
    /// Azure.ResourceManager.ContainerRegistry.Models.ContainerRegistryTaskRunContent.
    /// </summary>
    public ContainerRegistryRunContent RunRequest 
    {
        get { Initialize(); return _runRequest!; }
        set { Initialize(); AssignOrReplace(ref _runRequest, value); }
    }
    private ContainerRegistryRunContent? _runRequest;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// The provisioning state of this task run.
    /// </summary>
    public BicepValue<ContainerRegistryProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<ContainerRegistryProvisioningState>? _provisioningState;

    /// <summary>
    /// The result of this task run.
    /// </summary>
    public ContainerRegistryRunData RunResult 
    {
        get { Initialize(); return _runResult!; }
    }
    private ContainerRegistryRunData? _runResult;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent ContainerRegistryService.
    /// </summary>
    public ContainerRegistryService? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<ContainerRegistryService>? _parent;

    /// <summary>
    /// Creates a new ContainerRegistryTaskRun.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ContainerRegistryTaskRun resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ContainerRegistryTaskRun.</param>
    public ContainerRegistryTaskRun(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.ContainerRegistry/registries/taskRuns", resourceVersion ?? "2023-07-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerRegistryTaskRun.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _forceUpdateTag = DefineProperty<string>("ForceUpdateTag", ["properties", "forceUpdateTag"]);
        _identity = DefineModelProperty<ManagedServiceIdentity>("Identity", ["identity"]);
        _location = DefineProperty<AzureLocation>("Location", ["location"]);
        _runRequest = DefineModelProperty<ContainerRegistryRunContent>("RunRequest", ["properties", "runRequest"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _provisioningState = DefineProperty<ContainerRegistryProvisioningState>("ProvisioningState", ["properties", "provisioningState"], isOutput: true);
        _runResult = DefineModelProperty<ContainerRegistryRunData>("RunResult", ["properties", "runResult"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<ContainerRegistryService>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported ContainerRegistryTaskRun resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2023-07-01.
        /// </summary>
        public static readonly string V2023_07_01 = "2023-07-01";

        /// <summary>
        /// 2022-12-01.
        /// </summary>
        public static readonly string V2022_12_01 = "2022-12-01";

        /// <summary>
        /// 2021-09-01.
        /// </summary>
        public static readonly string V2021_09_01 = "2021-09-01";

        /// <summary>
        /// 2019-05-01.
        /// </summary>
        public static readonly string V2019_05_01 = "2019-05-01";

        /// <summary>
        /// 2017-10-01.
        /// </summary>
        public static readonly string V2017_10_01 = "2017-10-01";

        /// <summary>
        /// 2017-03-01.
        /// </summary>
        public static readonly string V2017_03_01 = "2017-03-01";
    }

    /// <summary>
    /// Creates a reference to an existing ContainerRegistryTaskRun.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ContainerRegistryTaskRun resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ContainerRegistryTaskRun.</param>
    /// <returns>The existing ContainerRegistryTaskRun resource.</returns>
    public static ContainerRegistryTaskRun FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
