// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;
using System.ComponentModel;

namespace Azure.Provisioning.ContainerRegistry;

/// <summary>
/// ContainerRegistryTask.
/// </summary>
public partial class ContainerRegistryTask : ProvisionableResource
{
    /// <summary>
    /// The name of the container registry task.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Gets or sets the Location.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
        set { Initialize(); _location!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// The CPU configuration in terms of number of cores required for the run.
    /// </summary>
    public BicepValue<int> AgentCpu 
    {
        get { Initialize(); return _agentCpu!; }
        set { Initialize(); _agentCpu!.Assign(value); }
    }
    private BicepValue<int>? _agentCpu;

    /// <summary>
    /// The dedicated agent pool for the task.
    /// </summary>
    public BicepValue<string> AgentPoolName 
    {
        get { Initialize(); return _agentPoolName!; }
        set { Initialize(); _agentPoolName!.Assign(value); }
    }
    private BicepValue<string>? _agentPoolName;

    /// <summary>
    /// The properties that describes a set of credentials that will be used
    /// when this run is invoked.
    /// </summary>
    public ContainerRegistryCredentials Credentials 
    {
        get { Initialize(); return _credentials!; }
        set { Initialize(); AssignOrReplace(ref _credentials, value); }
    }
    private ContainerRegistryCredentials? _credentials;

    /// <summary>
    /// Identity for the resource.
    /// </summary>
    public ManagedServiceIdentity Identity 
    {
        get { Initialize(); return _identity!; }
        set { Initialize(); AssignOrReplace(ref _identity, value); }
    }
    private ManagedServiceIdentity? _identity;

    /// <summary>
    /// The value of this property indicates whether the task resource is
    /// system task or not.
    /// </summary>
    public BicepValue<bool> IsSystemTask 
    {
        get { Initialize(); return _isSystemTask!; }
        set { Initialize(); _isSystemTask!.Assign(value); }
    }
    private BicepValue<bool>? _isSystemTask;

    /// <summary>
    /// The template that describes the repository and tag information for run
    /// log artifact.
    /// </summary>
    public BicepValue<string> LogTemplate 
    {
        get { Initialize(); return _logTemplate!; }
        set { Initialize(); _logTemplate!.Assign(value); }
    }
    private BicepValue<string>? _logTemplate;

    /// <summary>
    /// The platform properties against which the run has to happen.
    /// </summary>
    public ContainerRegistryPlatformProperties Platform 
    {
        get { Initialize(); return _platform!; }
        set { Initialize(); AssignOrReplace(ref _platform, value); }
    }
    private ContainerRegistryPlatformProperties? _platform;

    /// <summary>
    /// The current status of task.
    /// </summary>
    public BicepValue<ContainerRegistryTaskStatus> Status 
    {
        get { Initialize(); return _status!; }
        set { Initialize(); _status!.Assign(value); }
    }
    private BicepValue<ContainerRegistryTaskStatus>? _status;

    /// <summary>
    /// The properties of a task step.             Please note
    /// Azure.ResourceManager.ContainerRegistry.Models.ContainerRegistryTaskStepProperties
    /// is the base class. According to the scenario, a derived class of the
    /// base class might need to be assigned here, or this property needs to
    /// be casted to one of the possible derived classes.             The
    /// available derived classes include
    /// Azure.ResourceManager.ContainerRegistry.Models.ContainerRegistryDockerBuildStep,
    /// Azure.ResourceManager.ContainerRegistry.Models.ContainerRegistryEncodedTaskStep
    /// and
    /// Azure.ResourceManager.ContainerRegistry.Models.ContainerRegistryFileTaskStep.
    /// </summary>
    public ContainerRegistryTaskStepProperties Step 
    {
        get { Initialize(); return _step!; }
        set { Initialize(); AssignOrReplace(ref _step, value); }
    }
    private ContainerRegistryTaskStepProperties? _step;

    /// <summary>
    /// Gets or sets the Tags.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// Run timeout in seconds.
    /// </summary>
    public BicepValue<int> TimeoutInSeconds 
    {
        get { Initialize(); return _timeoutInSeconds!; }
        set { Initialize(); _timeoutInSeconds!.Assign(value); }
    }
    private BicepValue<int>? _timeoutInSeconds;

    /// <summary>
    /// The properties that describe all triggers for the task.
    /// </summary>
    public ContainerRegistryTriggerProperties Trigger 
    {
        get { Initialize(); return _trigger!; }
        set { Initialize(); AssignOrReplace(ref _trigger, value); }
    }
    private ContainerRegistryTriggerProperties? _trigger;

    /// <summary>
    /// The creation date of task.
    /// </summary>
    public BicepValue<DateTimeOffset> CreatedOn 
    {
        get { Initialize(); return _createdOn!; }
    }
    private BicepValue<DateTimeOffset>? _createdOn;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// The provisioning state of the task.
    /// </summary>
    public BicepValue<ContainerRegistryProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<ContainerRegistryProvisioningState>? _provisioningState;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent ContainerRegistryService.
    /// </summary>
    public ContainerRegistryService? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<ContainerRegistryService>? _parent;

    /// <summary>
    /// Creates a new ContainerRegistryTask.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ContainerRegistryTask resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ContainerRegistryTask.</param>
    public ContainerRegistryTask(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.ContainerRegistry/registries/tasks", resourceVersion ?? "2019-04-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerRegistryTask.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isRequired: true);
        _agentCpu = DefineProperty<int>("AgentCpu", ["properties", "agentConfiguration", "cpu"]);
        _agentPoolName = DefineProperty<string>("AgentPoolName", ["properties", "agentPoolName"]);
        _credentials = DefineModelProperty<ContainerRegistryCredentials>("Credentials", ["properties", "credentials"]);
        _identity = DefineModelProperty<ManagedServiceIdentity>("Identity", ["identity"]);
        _isSystemTask = DefineProperty<bool>("IsSystemTask", ["properties", "isSystemTask"]);
        _logTemplate = DefineProperty<string>("LogTemplate", ["properties", "logTemplate"]);
        _platform = DefineModelProperty<ContainerRegistryPlatformProperties>("Platform", ["properties", "platform"]);
        _status = DefineProperty<ContainerRegistryTaskStatus>("Status", ["properties", "status"]);
        _step = DefineModelProperty<ContainerRegistryTaskStepProperties>("Step", ["properties", "step"]);
        _tags = DefineDictionaryProperty<string>("Tags", ["tags"]);
        _timeoutInSeconds = DefineProperty<int>("TimeoutInSeconds", ["properties", "timeout"]);
        _trigger = DefineModelProperty<ContainerRegistryTriggerProperties>("Trigger", ["properties", "trigger"]);
        _createdOn = DefineProperty<DateTimeOffset>("CreatedOn", ["properties", "creationDate"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _provisioningState = DefineProperty<ContainerRegistryProvisioningState>("ProvisioningState", ["properties", "provisioningState"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<ContainerRegistryService>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported ContainerRegistryTask resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2019-04-01.
        /// </summary>
        public static readonly string V2019_04_01 = "2019-04-01";

        /// <summary>
        /// 2018-09-01.
        /// </summary>
        public static readonly string V2018_09_01 = "2018-09-01";
    }

    /// <summary>
    /// Creates a reference to an existing ContainerRegistryTask.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ContainerRegistryTask resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ContainerRegistryTask.</param>
    /// <returns>The existing ContainerRegistryTask resource.</returns>
    public static ContainerRegistryTask FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };

    /// <summary>
    /// Get the requirements for naming this ContainerRegistryTask resource.
    /// </summary>
    /// <returns>Naming requirements.</returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override ResourceNameRequirements GetResourceNameRequirements() =>
        new(minLength: 5, maxLength: 50, validCharacters: ResourceNameCharacters.LowercaseLetters | ResourceNameCharacters.UppercaseLetters | ResourceNameCharacters.Numbers | ResourceNameCharacters.Hyphen | ResourceNameCharacters.Underscore);
}
