// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using System;
using System.ComponentModel;

namespace Azure.Provisioning.ContainerRegistry;

/// <summary>
/// Built-in ContainerRegistry roles that you can assign to users, groups,
/// service principals, and managed identities.
/// </summary>
/// <param name="value">The ID value of the role.</param>
public readonly struct ContainerRegistryBuiltInRole(string value) : IEquatable<ContainerRegistryBuiltInRole>
{
    private readonly string _value = value ?? throw new ArgumentNullException(nameof(value));

    /// <summary>
    /// Delete repositories, tags, or manifests from a container registry.
    /// </summary>
    public static ContainerRegistryBuiltInRole AcrDelete { get; } = new(AcrDeleteValue);
    internal const string AcrDeleteValue = "c2f4ef07-c644-48eb-af81-4b1b4947fb11";

    /// <summary>
    /// Push trusted images to or pull trusted images from a container registry
    /// enabled for content trust.
    /// </summary>
    public static ContainerRegistryBuiltInRole AcrImageSigner { get; } = new(AcrImageSignerValue);
    internal const string AcrImageSignerValue = "6cef56e8-d556-48e5-a04f-b8e64114680f";

    /// <summary>
    /// Pull artifacts from a container registry.
    /// </summary>
    public static ContainerRegistryBuiltInRole AcrPull { get; } = new(AcrPullValue);
    internal const string AcrPullValue = "7f951dda-4ed3-4680-a7ca-43fe172d538d";

    /// <summary>
    /// Push artifacts to or pull artifacts from a container registry.
    /// </summary>
    public static ContainerRegistryBuiltInRole AcrPush { get; } = new(AcrPushValue);
    internal const string AcrPushValue = "8311e382-0749-4cb8-b61a-304f252e45ec";

    /// <summary>
    /// Pull quarantined images from a container registry.
    /// </summary>
    public static ContainerRegistryBuiltInRole AcrQuarantineReader { get; } = new(AcrQuarantineReaderValue);
    internal const string AcrQuarantineReaderValue = "cdda3590-29a3-44f6-95f2-9f980659eb04";

    /// <summary>
    /// Push quarantined images to or pull quarantined images from a container
    /// registry.
    /// </summary>
    public static ContainerRegistryBuiltInRole AcrQuarantineWriter { get; } = new(AcrQuarantineWriterValue);
    internal const string AcrQuarantineWriterValue = "c8d4ff99-41c3-41a8-9f60-21dfdad59608";

    /// <summary>
    /// Try to get the name of a built-in ContainerRegistry role from its ID
    /// value.
    /// </summary>
    /// <param name="value">The role value.</param>
    /// <returns>
    /// The name of the built-in ContainerRegistry role if known, otherwise the ID will be returned.
    /// </returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public static string GetBuiltInRoleName(ContainerRegistryBuiltInRole value) =>
        value._value switch
        {
            AcrDeleteValue => nameof(AcrDelete),
            AcrImageSignerValue => nameof(AcrImageSigner),
            AcrPullValue => nameof(AcrPull),
            AcrPushValue => nameof(AcrPush),
            AcrQuarantineReaderValue => nameof(AcrQuarantineReader),
            AcrQuarantineWriterValue => nameof(AcrQuarantineWriter),
            _ => value._value
        };

    /// <summary>
    /// Determines if two ContainerRegistryBuiltInRole values are the same.
    /// </summary>
    /// <param name="left">The first ContainerRegistryBuiltInRole to compare.</param>
    /// <param name="right">The second ContainerRegistryBuiltInRole to compare.</param>
    /// <returns>True if <paramref name="left"/> and <paramref name="right"/> are the same; otherwise, false.</returns>
    public static bool operator ==(ContainerRegistryBuiltInRole left, ContainerRegistryBuiltInRole right) => left.Equals(right);

    /// <summary>
    /// Determines if two ContainerRegistryBuiltInRole values are different.
    /// </summary>
    /// <param name="left">The first ContainerRegistryBuiltInRole to compare.</param>
    /// <param name="right">The second ContainerRegistryBuiltInRole to compare.</param>
    /// <returns>True if <paramref name="left"/> and <paramref name="right"/> are different; otherwise, false.</returns>
    public static bool operator !=(ContainerRegistryBuiltInRole left, ContainerRegistryBuiltInRole right) => !left.Equals(right);

    /// <summary>
    /// Converts a string to a ContainerRegistryBuiltInRole.
    /// </summary>
    /// <param name="value">The string value to convert.</param>
    public static implicit operator ContainerRegistryBuiltInRole(string value) => new(value);

    /// <inheritdoc/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override bool Equals(object? obj) => obj is ContainerRegistryBuiltInRole other && Equals(other);

    /// <inheritdoc/>
    public bool Equals(ContainerRegistryBuiltInRole other) => string.Equals(_value, other._value, StringComparison.Ordinal);

    /// <inheritdoc/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override int GetHashCode() => _value?.GetHashCode() ?? 0;

    /// <inheritdoc/>
    public override string ToString() => _value;
}
