// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.ContainerRegistry;

/// <summary>
/// ContainerRegistryAgentPool.
/// </summary>
public partial class ContainerRegistryAgentPool : ProvisionableResource
{
    /// <summary>
    /// The name of the agent pool.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Gets or sets the Location.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
        set { Initialize(); _location!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// The count of agent machine.
    /// </summary>
    public BicepValue<int> Count 
    {
        get { Initialize(); return _count!; }
        set { Initialize(); _count!.Assign(value); }
    }
    private BicepValue<int>? _count;

    /// <summary>
    /// The OS of agent machine.
    /// </summary>
    public BicepValue<ContainerRegistryOS> OS 
    {
        get { Initialize(); return _oS!; }
        set { Initialize(); _oS!.Assign(value); }
    }
    private BicepValue<ContainerRegistryOS>? _oS;

    /// <summary>
    /// Gets or sets the Tags.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// The Tier of agent machine.
    /// </summary>
    public BicepValue<string> Tier 
    {
        get { Initialize(); return _tier!; }
        set { Initialize(); _tier!.Assign(value); }
    }
    private BicepValue<string>? _tier;

    /// <summary>
    /// The Virtual Network Subnet Resource Id of the agent machine.
    /// </summary>
    public BicepValue<ResourceIdentifier> VirtualNetworkSubnetResourceId 
    {
        get { Initialize(); return _virtualNetworkSubnetResourceId!; }
        set { Initialize(); _virtualNetworkSubnetResourceId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _virtualNetworkSubnetResourceId;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// The provisioning state of this agent pool.
    /// </summary>
    public BicepValue<ContainerRegistryProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<ContainerRegistryProvisioningState>? _provisioningState;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent ContainerRegistryService.
    /// </summary>
    public ContainerRegistryService? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<ContainerRegistryService>? _parent;

    /// <summary>
    /// Creates a new ContainerRegistryAgentPool.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ContainerRegistryAgentPool
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ContainerRegistryAgentPool.</param>
    public ContainerRegistryAgentPool(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.ContainerRegistry/registries/agentPools", resourceVersion ?? "2023-07-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerRegistryAgentPool.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isRequired: true);
        _count = DefineProperty<int>("Count", ["properties", "count"]);
        _oS = DefineProperty<ContainerRegistryOS>("OS", ["properties", "os"]);
        _tags = DefineDictionaryProperty<string>("Tags", ["tags"]);
        _tier = DefineProperty<string>("Tier", ["properties", "tier"]);
        _virtualNetworkSubnetResourceId = DefineProperty<ResourceIdentifier>("VirtualNetworkSubnetResourceId", ["properties", "virtualNetworkSubnetResourceId"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _provisioningState = DefineProperty<ContainerRegistryProvisioningState>("ProvisioningState", ["properties", "provisioningState"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<ContainerRegistryService>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported ContainerRegistryAgentPool resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2023-07-01.
        /// </summary>
        public static readonly string V2023_07_01 = "2023-07-01";

        /// <summary>
        /// 2022-12-01.
        /// </summary>
        public static readonly string V2022_12_01 = "2022-12-01";

        /// <summary>
        /// 2021-09-01.
        /// </summary>
        public static readonly string V2021_09_01 = "2021-09-01";

        /// <summary>
        /// 2019-05-01.
        /// </summary>
        public static readonly string V2019_05_01 = "2019-05-01";

        /// <summary>
        /// 2017-10-01.
        /// </summary>
        public static readonly string V2017_10_01 = "2017-10-01";

        /// <summary>
        /// 2017-03-01.
        /// </summary>
        public static readonly string V2017_03_01 = "2017-03-01";
    }

    /// <summary>
    /// Creates a reference to an existing ContainerRegistryAgentPool.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ContainerRegistryAgentPool
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ContainerRegistryAgentPool.</param>
    /// <returns>The existing ContainerRegistryAgentPool resource.</returns>
    public static ContainerRegistryAgentPool FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
