// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.Communication;

/// <summary>
/// SenderUsername.
/// </summary>
public partial class SenderUsername : ProvisionableResource
{
    /// <summary>
    /// The valid sender Username.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The display name for the senderUsername.
    /// </summary>
    public BicepValue<string> DisplayName 
    {
        get { Initialize(); return _displayName!; }
        set { Initialize(); _displayName!.Assign(value); }
    }
    private BicepValue<string>? _displayName;

    /// <summary>
    /// A sender senderUsername to be used when sending emails.
    /// </summary>
    public BicepValue<string> Username 
    {
        get { Initialize(); return _username!; }
        set { Initialize(); _username!.Assign(value); }
    }
    private BicepValue<string>? _username;

    /// <summary>
    /// The location where the SenderUsername resource data is stored at rest.
    /// </summary>
    public BicepValue<string> DataLocation 
    {
        get { Initialize(); return _dataLocation!; }
    }
    private BicepValue<string>? _dataLocation;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Provisioning state of the resource. Unknown is the default state for
    /// Communication Services.
    /// </summary>
    public BicepValue<CommunicationServiceProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<CommunicationServiceProvisioningState>? _provisioningState;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent CommunicationDomain.
    /// </summary>
    public CommunicationDomain? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<CommunicationDomain>? _parent;

    /// <summary>
    /// Creates a new SenderUsername.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the SenderUsername resource.  This can
    /// be used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SenderUsername.</param>
    public SenderUsername(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Communication/emailServices/domains/senderUsernames", resourceVersion ?? "2023-04-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of SenderUsername.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _displayName = DefineProperty<string>("DisplayName", ["properties", "displayName"]);
        _username = DefineProperty<string>("Username", ["properties", "username"]);
        _dataLocation = DefineProperty<string>("DataLocation", ["properties", "dataLocation"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _provisioningState = DefineProperty<CommunicationServiceProvisioningState>("ProvisioningState", ["properties", "provisioningState"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<CommunicationDomain>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported SenderUsername resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2023-04-01.
        /// </summary>
        public static readonly string V2023_04_01 = "2023-04-01";

        /// <summary>
        /// 2023-03-31.
        /// </summary>
        public static readonly string V2023_03_31 = "2023-03-31";
    }

    /// <summary>
    /// Creates a reference to an existing SenderUsername.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the SenderUsername resource.  This can
    /// be used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SenderUsername.</param>
    /// <returns>The existing SenderUsername resource.</returns>
    public static SenderUsername FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
