// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Communication;

/// <summary>
/// A class that represents a VerificationStatus record.
/// </summary>
public partial class VerificationDnsRecord : ProvisionableConstruct
{
    /// <summary>
    /// Type of the DNS record. Example: TXT.
    /// </summary>
    public BicepValue<string> DnsRecordType 
    {
        get { Initialize(); return _dnsRecordType!; }
    }
    private BicepValue<string>? _dnsRecordType;

    /// <summary>
    /// Name of the DNS record.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Value of the DNS record.
    /// </summary>
    public BicepValue<string> Value 
    {
        get { Initialize(); return _value!; }
    }
    private BicepValue<string>? _value;

    /// <summary>
    /// Represents an expiry time in seconds to represent how long this entry
    /// can be cached by the resolver, default = 3600sec.
    /// </summary>
    public BicepValue<int> TimeToLiveInSeconds 
    {
        get { Initialize(); return _timeToLiveInSeconds!; }
    }
    private BicepValue<int>? _timeToLiveInSeconds;

    /// <summary>
    /// Creates a new VerificationDnsRecord.
    /// </summary>
    public VerificationDnsRecord()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of VerificationDnsRecord.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _dnsRecordType = DefineProperty<string>("DnsRecordType", ["type"], isOutput: true);
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _value = DefineProperty<string>("Value", ["value"], isOutput: true);
        _timeToLiveInSeconds = DefineProperty<int>("TimeToLiveInSeconds", ["ttl"], isOutput: true);
    }
}
