// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Communication;

/// <summary>
/// A class that represents a VerificationStatus record.
/// </summary>
public partial class DomainVerificationStatusRecord : ProvisionableConstruct
{
    /// <summary>
    /// Status of the verification operation.
    /// </summary>
    public BicepValue<DomainRecordVerificationStatus> Status 
    {
        get { Initialize(); return _status!; }
    }
    private BicepValue<DomainRecordVerificationStatus>? _status;

    /// <summary>
    /// Error code. This property will only be present if the status is
    /// UnableToVerify.
    /// </summary>
    public BicepValue<string> ErrorCode 
    {
        get { Initialize(); return _errorCode!; }
    }
    private BicepValue<string>? _errorCode;

    /// <summary>
    /// Creates a new DomainVerificationStatusRecord.
    /// </summary>
    public DomainVerificationStatusRecord()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// DomainVerificationStatusRecord.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _status = DefineProperty<DomainRecordVerificationStatus>("Status", ["status"], isOutput: true);
        _errorCode = DefineProperty<string>("ErrorCode", ["errorCode"], isOutput: true);
    }
}
