// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Communication;

/// <summary>
/// List of VerificationStatusRecord.
/// </summary>
public partial class DomainPropertiesVerificationStates : ProvisionableConstruct
{
    /// <summary>
    /// A class that represents a VerificationStatus record.
    /// </summary>
    public DomainVerificationStatusRecord Domain 
    {
        get { Initialize(); return _domain!; }
    }
    private DomainVerificationStatusRecord? _domain;

    /// <summary>
    /// A class that represents a VerificationStatus record.
    /// </summary>
    public DomainVerificationStatusRecord Spf 
    {
        get { Initialize(); return _spf!; }
    }
    private DomainVerificationStatusRecord? _spf;

    /// <summary>
    /// A class that represents a VerificationStatus record.
    /// </summary>
    public DomainVerificationStatusRecord Dkim 
    {
        get { Initialize(); return _dkim!; }
    }
    private DomainVerificationStatusRecord? _dkim;

    /// <summary>
    /// A class that represents a VerificationStatus record.
    /// </summary>
    public DomainVerificationStatusRecord Dkim2 
    {
        get { Initialize(); return _dkim2!; }
    }
    private DomainVerificationStatusRecord? _dkim2;

    /// <summary>
    /// A class that represents a VerificationStatus record.
    /// </summary>
    public DomainVerificationStatusRecord Dmarc 
    {
        get { Initialize(); return _dmarc!; }
    }
    private DomainVerificationStatusRecord? _dmarc;

    /// <summary>
    /// Creates a new DomainPropertiesVerificationStates.
    /// </summary>
    public DomainPropertiesVerificationStates()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// DomainPropertiesVerificationStates.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _domain = DefineModelProperty<DomainVerificationStatusRecord>("Domain", ["Domain"], isOutput: true);
        _spf = DefineModelProperty<DomainVerificationStatusRecord>("Spf", ["SPF"], isOutput: true);
        _dkim = DefineModelProperty<DomainVerificationStatusRecord>("Dkim", ["DKIM"], isOutput: true);
        _dkim2 = DefineModelProperty<DomainVerificationStatusRecord>("Dkim2", ["DKIM2"], isOutput: true);
        _dmarc = DefineModelProperty<DomainVerificationStatusRecord>("Dmarc", ["DMARC"], isOutput: true);
    }
}
