// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Communication;

/// <summary>
/// List of DnsRecord.
/// </summary>
public partial class DomainPropertiesVerificationRecords : ProvisionableConstruct
{
    /// <summary>
    /// A class that represents a VerificationStatus record.
    /// </summary>
    public VerificationDnsRecord Domain 
    {
        get { Initialize(); return _domain!; }
    }
    private VerificationDnsRecord? _domain;

    /// <summary>
    /// A class that represents a VerificationStatus record.
    /// </summary>
    public VerificationDnsRecord Spf 
    {
        get { Initialize(); return _spf!; }
    }
    private VerificationDnsRecord? _spf;

    /// <summary>
    /// A class that represents a VerificationStatus record.
    /// </summary>
    public VerificationDnsRecord Dkim 
    {
        get { Initialize(); return _dkim!; }
    }
    private VerificationDnsRecord? _dkim;

    /// <summary>
    /// A class that represents a VerificationStatus record.
    /// </summary>
    public VerificationDnsRecord Dkim2 
    {
        get { Initialize(); return _dkim2!; }
    }
    private VerificationDnsRecord? _dkim2;

    /// <summary>
    /// A class that represents a VerificationStatus record.
    /// </summary>
    public VerificationDnsRecord Dmarc 
    {
        get { Initialize(); return _dmarc!; }
    }
    private VerificationDnsRecord? _dmarc;

    /// <summary>
    /// Creates a new DomainPropertiesVerificationRecords.
    /// </summary>
    public DomainPropertiesVerificationRecords()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// DomainPropertiesVerificationRecords.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _domain = DefineModelProperty<VerificationDnsRecord>("Domain", ["Domain"], isOutput: true);
        _spf = DefineModelProperty<VerificationDnsRecord>("Spf", ["SPF"], isOutput: true);
        _dkim = DefineModelProperty<VerificationDnsRecord>("Dkim", ["DKIM"], isOutput: true);
        _dkim2 = DefineModelProperty<VerificationDnsRecord>("Dkim2", ["DKIM2"], isOutput: true);
        _dmarc = DefineModelProperty<VerificationDnsRecord>("Dmarc", ["DMARC"], isOutput: true);
    }
}
