// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Expressions;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;
using System.ComponentModel;

namespace Azure.Provisioning.Communication;

/// <summary>
/// CommunicationService.
/// </summary>
public partial class CommunicationService : ProvisionableResource
{
    /// <summary>
    /// The name of the CommunicationService resource.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Gets or sets the Location.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
        set { Initialize(); _location!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// The location where the communication service stores its data at rest.
    /// </summary>
    public BicepValue<string> DataLocation 
    {
        get { Initialize(); return _dataLocation!; }
        set { Initialize(); _dataLocation!.Assign(value); }
    }
    private BicepValue<string>? _dataLocation;

    /// <summary>
    /// Managed service identity (system assigned and/or user assigned
    /// identities).
    /// </summary>
    public ManagedServiceIdentity Identity 
    {
        get { Initialize(); return _identity!; }
        set { Initialize(); AssignOrReplace(ref _identity, value); }
    }
    private ManagedServiceIdentity? _identity;

    /// <summary>
    /// List of email Domain resource Ids.
    /// </summary>
    public BicepList<string> LinkedDomains 
    {
        get { Initialize(); return _linkedDomains!; }
        set { Initialize(); _linkedDomains!.Assign(value); }
    }
    private BicepList<string>? _linkedDomains;

    /// <summary>
    /// Gets or sets the Tags.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// FQDN of the CommunicationService instance.
    /// </summary>
    public BicepValue<string> HostName 
    {
        get { Initialize(); return _hostName!; }
    }
    private BicepValue<string>? _hostName;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// The immutable resource Id of the communication service.
    /// </summary>
    public BicepValue<Guid> ImmutableResourceId 
    {
        get { Initialize(); return _immutableResourceId!; }
    }
    private BicepValue<Guid>? _immutableResourceId;

    /// <summary>
    /// Resource ID of an Azure Notification Hub linked to this resource.
    /// </summary>
    public BicepValue<ResourceIdentifier> NotificationHubId 
    {
        get { Initialize(); return _notificationHubId!; }
    }
    private BicepValue<ResourceIdentifier>? _notificationHubId;

    /// <summary>
    /// Provisioning state of the resource.
    /// </summary>
    public BicepValue<CommunicationServicesProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<CommunicationServicesProvisioningState>? _provisioningState;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Version of the CommunicationService resource. Probably you need the
    /// same or higher version of client SDKs.
    /// </summary>
    public BicepValue<string> Version 
    {
        get { Initialize(); return _version!; }
    }
    private BicepValue<string>? _version;

    /// <summary>
    /// Creates a new CommunicationService.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the CommunicationService resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the CommunicationService.</param>
    public CommunicationService(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Communication/communicationServices", resourceVersion ?? "2023-04-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of CommunicationService.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isRequired: true);
        _dataLocation = DefineProperty<string>("DataLocation", ["properties", "dataLocation"]);
        _identity = DefineModelProperty<ManagedServiceIdentity>("Identity", ["identity"]);
        _linkedDomains = DefineListProperty<string>("LinkedDomains", ["properties", "linkedDomains"]);
        _tags = DefineDictionaryProperty<string>("Tags", ["tags"]);
        _hostName = DefineProperty<string>("HostName", ["properties", "hostName"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _immutableResourceId = DefineProperty<Guid>("ImmutableResourceId", ["properties", "immutableResourceId"], isOutput: true);
        _notificationHubId = DefineProperty<ResourceIdentifier>("NotificationHubId", ["properties", "notificationHubId"], isOutput: true);
        _provisioningState = DefineProperty<CommunicationServicesProvisioningState>("ProvisioningState", ["properties", "provisioningState"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _version = DefineProperty<string>("Version", ["properties", "version"], isOutput: true);
    }

    /// <summary>
    /// Supported CommunicationService resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2023-04-01.
        /// </summary>
        public static readonly string V2023_04_01 = "2023-04-01";

        /// <summary>
        /// 2023-03-31.
        /// </summary>
        public static readonly string V2023_03_31 = "2023-03-31";

        /// <summary>
        /// 2020-08-20.
        /// </summary>
        public static readonly string V2020_08_20 = "2020-08-20";
    }

    /// <summary>
    /// Creates a reference to an existing CommunicationService.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the CommunicationService resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the CommunicationService.</param>
    /// <returns>The existing CommunicationService resource.</returns>
    public static CommunicationService FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };

    /// <summary>
    /// Get the requirements for naming this CommunicationService resource.
    /// </summary>
    /// <returns>Naming requirements.</returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override ResourceNameRequirements GetResourceNameRequirements() =>
        new(minLength: 1, maxLength: 63, validCharacters: ResourceNameCharacters.LowercaseLetters | ResourceNameCharacters.UppercaseLetters | ResourceNameCharacters.Numbers | ResourceNameCharacters.Hyphen);

    /// <summary>
    /// Get access keys for this CommunicationService resource.
    /// </summary>
    /// <returns>The keys for this CommunicationService resource.</returns>
    public CommunicationServiceKeys GetKeys()
    {
        CommunicationServiceKeys key = new();
        ((IBicepValue)key).Expression = new FunctionCallExpression(new MemberExpression(new IdentifierExpression(BicepIdentifier), "listKeys"));
        return key;
    }
}
