// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.Communication;

/// <summary>
/// CommunicationDomain.
/// </summary>
public partial class CommunicationDomain : ProvisionableResource
{
    /// <summary>
    /// The name of the Domains resource.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Gets or sets the Location.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
        set { Initialize(); _location!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// Describes how a Domains resource is being managed.
    /// </summary>
    public BicepValue<DomainManagement> DomainManagement 
    {
        get { Initialize(); return _domainManagement!; }
        set { Initialize(); _domainManagement!.Assign(value); }
    }
    private BicepValue<DomainManagement>? _domainManagement;

    /// <summary>
    /// Gets or sets the Tags.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// Describes whether user engagement tracking is enabled or disabled.
    /// </summary>
    public BicepValue<UserEngagementTracking> UserEngagementTracking 
    {
        get { Initialize(); return _userEngagementTracking!; }
        set { Initialize(); _userEngagementTracking!.Assign(value); }
    }
    private BicepValue<UserEngagementTracking>? _userEngagementTracking;

    /// <summary>
    /// The location where the Domains resource data is stored at rest.
    /// </summary>
    public BicepValue<string> DataLocation 
    {
        get { Initialize(); return _dataLocation!; }
    }
    private BicepValue<string>? _dataLocation;

    /// <summary>
    /// P2 sender domain that is displayed to the email recipients [RFC 5322].
    /// </summary>
    public BicepValue<string> FromSenderDomain 
    {
        get { Initialize(); return _fromSenderDomain!; }
    }
    private BicepValue<string>? _fromSenderDomain;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// P1 sender domain that is present on the email envelope [RFC 5321].
    /// </summary>
    public BicepValue<string> MailFromSenderDomain 
    {
        get { Initialize(); return _mailFromSenderDomain!; }
    }
    private BicepValue<string>? _mailFromSenderDomain;

    /// <summary>
    /// Provisioning state of the resource.
    /// </summary>
    public BicepValue<DomainProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<DomainProvisioningState>? _provisioningState;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// List of DnsRecord.
    /// </summary>
    public DomainPropertiesVerificationRecords VerificationRecords 
    {
        get { Initialize(); return _verificationRecords!; }
    }
    private DomainPropertiesVerificationRecords? _verificationRecords;

    /// <summary>
    /// List of VerificationStatusRecord.
    /// </summary>
    public DomainPropertiesVerificationStates VerificationStates 
    {
        get { Initialize(); return _verificationStates!; }
    }
    private DomainPropertiesVerificationStates? _verificationStates;

    /// <summary>
    /// Gets or sets a reference to the parent EmailService.
    /// </summary>
    public EmailService? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<EmailService>? _parent;

    /// <summary>
    /// Creates a new CommunicationDomain.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the CommunicationDomain resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the CommunicationDomain.</param>
    public CommunicationDomain(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Communication/emailServices/domains", resourceVersion ?? "2023-04-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of CommunicationDomain.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isRequired: true);
        _domainManagement = DefineProperty<DomainManagement>("DomainManagement", ["properties", "domainManagement"]);
        _tags = DefineDictionaryProperty<string>("Tags", ["tags"]);
        _userEngagementTracking = DefineProperty<UserEngagementTracking>("UserEngagementTracking", ["properties", "userEngagementTracking"]);
        _dataLocation = DefineProperty<string>("DataLocation", ["properties", "dataLocation"], isOutput: true);
        _fromSenderDomain = DefineProperty<string>("FromSenderDomain", ["properties", "fromSenderDomain"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _mailFromSenderDomain = DefineProperty<string>("MailFromSenderDomain", ["properties", "mailFromSenderDomain"], isOutput: true);
        _provisioningState = DefineProperty<DomainProvisioningState>("ProvisioningState", ["properties", "provisioningState"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _verificationRecords = DefineModelProperty<DomainPropertiesVerificationRecords>("VerificationRecords", ["properties", "verificationRecords"], isOutput: true);
        _verificationStates = DefineModelProperty<DomainPropertiesVerificationStates>("VerificationStates", ["properties", "verificationStates"], isOutput: true);
        _parent = DefineResource<EmailService>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported CommunicationDomain resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2023-04-01.
        /// </summary>
        public static readonly string V2023_04_01 = "2023-04-01";

        /// <summary>
        /// 2023-03-31.
        /// </summary>
        public static readonly string V2023_03_31 = "2023-03-31";
    }

    /// <summary>
    /// Creates a reference to an existing CommunicationDomain.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the CommunicationDomain resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the CommunicationDomain.</param>
    /// <returns>The existing CommunicationDomain resource.</returns>
    public static CommunicationDomain FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
