// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CognitiveServices;

/// <summary>
/// The ServiceAccountThrottlingRule.
/// </summary>
public partial class ServiceAccountThrottlingRule : ProvisionableConstruct
{
    /// <summary>
    /// Gets the key.
    /// </summary>
    public BicepValue<string> Key 
    {
        get { Initialize(); return _key!; }
    }
    private BicepValue<string>? _key;

    /// <summary>
    /// Gets the renewal period.
    /// </summary>
    public BicepValue<float> RenewalPeriod 
    {
        get { Initialize(); return _renewalPeriod!; }
    }
    private BicepValue<float>? _renewalPeriod;

    /// <summary>
    /// Gets the count.
    /// </summary>
    public BicepValue<float> Count 
    {
        get { Initialize(); return _count!; }
    }
    private BicepValue<float>? _count;

    /// <summary>
    /// Gets the min count.
    /// </summary>
    public BicepValue<float> MinCount 
    {
        get { Initialize(); return _minCount!; }
    }
    private BicepValue<float>? _minCount;

    /// <summary>
    /// Gets the is dynamic throttling enabled.
    /// </summary>
    public BicepValue<bool> IsDynamicThrottlingEnabled 
    {
        get { Initialize(); return _isDynamicThrottlingEnabled!; }
    }
    private BicepValue<bool>? _isDynamicThrottlingEnabled;

    /// <summary>
    /// Gets the match patterns.
    /// </summary>
    public BicepList<ServiceAccountThrottlingMatchPattern> MatchPatterns 
    {
        get { Initialize(); return _matchPatterns!; }
    }
    private BicepList<ServiceAccountThrottlingMatchPattern>? _matchPatterns;

    /// <summary>
    /// Creates a new ServiceAccountThrottlingRule.
    /// </summary>
    public ServiceAccountThrottlingRule()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ServiceAccountThrottlingRule.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _key = DefineProperty<string>("Key", ["key"], isOutput: true);
        _renewalPeriod = DefineProperty<float>("RenewalPeriod", ["renewalPeriod"], isOutput: true);
        _count = DefineProperty<float>("Count", ["count"], isOutput: true);
        _minCount = DefineProperty<float>("MinCount", ["minCount"], isOutput: true);
        _isDynamicThrottlingEnabled = DefineProperty<bool>("IsDynamicThrottlingEnabled", ["dynamicThrottlingEnabled"], isOutput: true);
        _matchPatterns = DefineListProperty<ServiceAccountThrottlingMatchPattern>("MatchPatterns", ["matchPatterns"], isOutput: true);
    }
}
