// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CognitiveServices;

/// <summary>
/// The ServiceAccountThrottlingMatchPattern.
/// </summary>
public partial class ServiceAccountThrottlingMatchPattern : ProvisionableConstruct
{
    /// <summary>
    /// Gets the path.
    /// </summary>
    public BicepValue<string> Path 
    {
        get { Initialize(); return _path!; }
    }
    private BicepValue<string>? _path;

    /// <summary>
    /// Gets the method.
    /// </summary>
    public BicepValue<string> Method 
    {
        get { Initialize(); return _method!; }
    }
    private BicepValue<string>? _method;

    /// <summary>
    /// Creates a new ServiceAccountThrottlingMatchPattern.
    /// </summary>
    public ServiceAccountThrottlingMatchPattern()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ServiceAccountThrottlingMatchPattern.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _path = DefineProperty<string>("Path", ["path"], isOutput: true);
        _method = DefineProperty<string>("Method", ["method"], isOutput: true);
    }
}
