// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CognitiveServices;

/// <summary>
/// The ServiceAccountQuotaLimit.
/// </summary>
public partial class ServiceAccountQuotaLimit : ProvisionableConstruct
{
    /// <summary>
    /// Gets the count.
    /// </summary>
    public BicepValue<float> Count 
    {
        get { Initialize(); return _count!; }
    }
    private BicepValue<float>? _count;

    /// <summary>
    /// Gets the renewal period.
    /// </summary>
    public BicepValue<float> RenewalPeriod 
    {
        get { Initialize(); return _renewalPeriod!; }
    }
    private BicepValue<float>? _renewalPeriod;

    /// <summary>
    /// Gets the rules.
    /// </summary>
    public BicepList<ServiceAccountThrottlingRule> Rules 
    {
        get { Initialize(); return _rules!; }
    }
    private BicepList<ServiceAccountThrottlingRule>? _rules;

    /// <summary>
    /// Creates a new ServiceAccountQuotaLimit.
    /// </summary>
    public ServiceAccountQuotaLimit()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ServiceAccountQuotaLimit.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _count = DefineProperty<float>("Count", ["count"], isOutput: true);
        _renewalPeriod = DefineProperty<float>("RenewalPeriod", ["renewalPeriod"], isOutput: true);
        _rules = DefineListProperty<ServiceAccountThrottlingRule>("Rules", ["rules"], isOutput: true);
    }
}
