// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CognitiveServices;

/// <summary>
/// Properties to configure Encryption.
/// </summary>
public partial class ServiceAccountEncryptionProperties : ProvisionableConstruct
{
    /// <summary>
    /// Properties of KeyVault.
    /// </summary>
    public CognitiveServicesKeyVaultProperties KeyVaultProperties 
    {
        get { Initialize(); return _keyVaultProperties!; }
        set { Initialize(); AssignOrReplace(ref _keyVaultProperties, value); }
    }
    private CognitiveServicesKeyVaultProperties? _keyVaultProperties;

    /// <summary>
    /// Enumerates the possible value of keySource for Encryption.
    /// </summary>
    public BicepValue<ServiceAccountEncryptionKeySource> KeySource 
    {
        get { Initialize(); return _keySource!; }
        set { Initialize(); _keySource!.Assign(value); }
    }
    private BicepValue<ServiceAccountEncryptionKeySource>? _keySource;

    /// <summary>
    /// Creates a new ServiceAccountEncryptionProperties.
    /// </summary>
    public ServiceAccountEncryptionProperties()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ServiceAccountEncryptionProperties.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _keyVaultProperties = DefineModelProperty<CognitiveServicesKeyVaultProperties>("KeyVaultProperties", ["keyVaultProperties"]);
        _keySource = DefineProperty<ServiceAccountEncryptionKeySource>("KeySource", ["keySource"]);
    }
}
