// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CognitiveServices;

/// <summary>
/// The call rate limit Cognitive Services account.
/// </summary>
public partial class ServiceAccountCallRateLimit : ProvisionableConstruct
{
    /// <summary>
    /// The count value of Call Rate Limit.
    /// </summary>
    public BicepValue<float> Count 
    {
        get { Initialize(); return _count!; }
    }
    private BicepValue<float>? _count;

    /// <summary>
    /// The renewal period in seconds of Call Rate Limit.
    /// </summary>
    public BicepValue<float> RenewalPeriod 
    {
        get { Initialize(); return _renewalPeriod!; }
    }
    private BicepValue<float>? _renewalPeriod;

    /// <summary>
    /// Gets the rules.
    /// </summary>
    public BicepList<ServiceAccountThrottlingRule> Rules 
    {
        get { Initialize(); return _rules!; }
    }
    private BicepList<ServiceAccountThrottlingRule>? _rules;

    /// <summary>
    /// Creates a new ServiceAccountCallRateLimit.
    /// </summary>
    public ServiceAccountCallRateLimit()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ServiceAccountCallRateLimit.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _count = DefineProperty<float>("Count", ["count"], isOutput: true);
        _renewalPeriod = DefineProperty<float>("RenewalPeriod", ["renewalPeriod"], isOutput: true);
        _rules = DefineListProperty<ServiceAccountThrottlingRule>("Rules", ["rules"], isOutput: true);
    }
}
