// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CognitiveServices;

/// <summary>
/// The api properties for special APIs.
/// </summary>
public partial class ServiceAccountApiProperties : ProvisionableConstruct
{
    /// <summary>
    /// (QnAMaker Only) The runtime endpoint of QnAMaker.
    /// </summary>
    public BicepValue<string> QnaRuntimeEndpoint 
    {
        get { Initialize(); return _qnaRuntimeEndpoint!; }
        set { Initialize(); _qnaRuntimeEndpoint!.Assign(value); }
    }
    private BicepValue<string>? _qnaRuntimeEndpoint;

    /// <summary>
    /// (QnAMaker Only) The Azure Search endpoint key of QnAMaker.
    /// </summary>
    public BicepValue<string> QnaAzureSearchEndpointKey 
    {
        get { Initialize(); return _qnaAzureSearchEndpointKey!; }
        set { Initialize(); _qnaAzureSearchEndpointKey!.Assign(value); }
    }
    private BicepValue<string>? _qnaAzureSearchEndpointKey;

    /// <summary>
    /// (QnAMaker Only) The Azure Search endpoint id of QnAMaker.
    /// </summary>
    public BicepValue<ResourceIdentifier> QnaAzureSearchEndpointId 
    {
        get { Initialize(); return _qnaAzureSearchEndpointId!; }
        set { Initialize(); _qnaAzureSearchEndpointId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _qnaAzureSearchEndpointId;

    /// <summary>
    /// (Bing Search Only) The flag to enable statistics of Bing Search.
    /// </summary>
    public BicepValue<bool> EnableStatistics 
    {
        get { Initialize(); return _enableStatistics!; }
        set { Initialize(); _enableStatistics!.Assign(value); }
    }
    private BicepValue<bool>? _enableStatistics;

    /// <summary>
    /// (Personalization Only) The flag to enable statistics of Bing Search.
    /// </summary>
    public BicepValue<string> EventHubConnectionString 
    {
        get { Initialize(); return _eventHubConnectionString!; }
        set { Initialize(); _eventHubConnectionString!.Assign(value); }
    }
    private BicepValue<string>? _eventHubConnectionString;

    /// <summary>
    /// (Personalization Only) The storage account connection string.
    /// </summary>
    public BicepValue<string> StorageAccountConnectionString 
    {
        get { Initialize(); return _storageAccountConnectionString!; }
        set { Initialize(); _storageAccountConnectionString!.Assign(value); }
    }
    private BicepValue<string>? _storageAccountConnectionString;

    /// <summary>
    /// (Metrics Advisor Only) The Azure AD Client Id (Application Id).
    /// </summary>
    public BicepValue<Guid> AadClientId 
    {
        get { Initialize(); return _aadClientId!; }
        set { Initialize(); _aadClientId!.Assign(value); }
    }
    private BicepValue<Guid>? _aadClientId;

    /// <summary>
    /// (Metrics Advisor Only) The Azure AD Tenant Id.
    /// </summary>
    public BicepValue<Guid> AadTenantId 
    {
        get { Initialize(); return _aadTenantId!; }
        set { Initialize(); _aadTenantId!.Assign(value); }
    }
    private BicepValue<Guid>? _aadTenantId;

    /// <summary>
    /// (Metrics Advisor Only) The super user of Metrics Advisor.
    /// </summary>
    public BicepValue<string> SuperUser 
    {
        get { Initialize(); return _superUser!; }
        set { Initialize(); _superUser!.Assign(value); }
    }
    private BicepValue<string>? _superUser;

    /// <summary>
    /// (Metrics Advisor Only) The website name of Metrics Advisor.
    /// </summary>
    public BicepValue<string> WebsiteName 
    {
        get { Initialize(); return _websiteName!; }
        set { Initialize(); _websiteName!.Assign(value); }
    }
    private BicepValue<string>? _websiteName;

    /// <summary>
    /// Additional Properties                          To assign an object to
    /// the value of this property use
    /// System.BinaryData.FromObjectAsJson``1(``0,System.Text.Json.JsonSerializerOptions).
    /// To assign an already formatted json string to
    /// this property use System.BinaryData.FromString(System.String).
    /// Examples:
    /// BinaryData.FromObjectAsJson(&quot;foo&quot;)Creates a
    /// payload of
    /// &quot;foo&quot;.BinaryData.FromString(&quot;\&quot;foo\&quot;&quot;)Creates
    /// a payload of &quot;foo&quot;.BinaryData.FromObjectAsJson(new { key =
    /// &quot;value&quot; })Creates a payload of { &quot;key&quot;:
    /// &quot;value&quot; }.BinaryData.FromString(&quot;{\&quot;key\&quot;:
    /// \&quot;value\&quot;}&quot;)Creates a payload of { &quot;key&quot;:
    /// &quot;value&quot; }.
    /// </summary>
    public BicepDictionary<BinaryData> AdditionalProperties 
    {
        get { Initialize(); return _additionalProperties!; }
        set { Initialize(); _additionalProperties!.Assign(value); }
    }
    private BicepDictionary<BinaryData>? _additionalProperties;

    /// <summary>
    /// Creates a new ServiceAccountApiProperties.
    /// </summary>
    public ServiceAccountApiProperties()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ServiceAccountApiProperties.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _qnaRuntimeEndpoint = DefineProperty<string>("QnaRuntimeEndpoint", ["qnaRuntimeEndpoint"]);
        _qnaAzureSearchEndpointKey = DefineProperty<string>("QnaAzureSearchEndpointKey", ["qnaAzureSearchEndpointKey"]);
        _qnaAzureSearchEndpointId = DefineProperty<ResourceIdentifier>("QnaAzureSearchEndpointId", ["qnaAzureSearchEndpointId"]);
        _enableStatistics = DefineProperty<bool>("EnableStatistics", ["statisticsEnabled"]);
        _eventHubConnectionString = DefineProperty<string>("EventHubConnectionString", ["eventHubConnectionString"]);
        _storageAccountConnectionString = DefineProperty<string>("StorageAccountConnectionString", ["storageAccountConnectionString"]);
        _aadClientId = DefineProperty<Guid>("AadClientId", ["aadClientId"]);
        _aadTenantId = DefineProperty<Guid>("AadTenantId", ["aadTenantId"]);
        _superUser = DefineProperty<string>("SuperUser", ["superUser"]);
        _websiteName = DefineProperty<string>("WebsiteName", ["websiteName"]);
        _additionalProperties = DefineDictionaryProperty<BinaryData>("AdditionalProperties", ["AdditionalProperties"]);
    }
}
